/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity;

import com.lovetropics.extras.entity.ExtraEntities;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.level.Level;

public class AmazonRiverDolphin
extends Dolphin {
    private static final EntityDataAccessor<Boolean> MOUTH_OPEN = SynchedEntityData.defineId(AmazonRiverDolphin.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public AmazonRiverDolphin(EntityType<? extends AmazonRiverDolphin> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MOUTH_OPEN, (Object)false);
    }

    @Nullable
    public Dolphin getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return (Dolphin)ExtraEntities.AMAZON_RIVER_DOLPHIN.create((Level)level, EntitySpawnReason.BREEDING);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.ambientSoundTime < -(this.getAmbientSoundInterval() - 20)) {
                if (this.tickCount % 3 > 1) {
                    if (!this.getMouthOpen()) {
                        this.setMouthOpen(true);
                    }
                } else if (this.getMouthOpen()) {
                    this.setMouthOpen(false);
                }
            } else if (this.getMouthOpen()) {
                this.setMouthOpen(false);
            }
        }
    }

    public void setMouthOpen(boolean b) {
        this.getEntityData().set(MOUTH_OPEN, (Object)b);
    }

    public boolean getMouthOpen() {
        return (Boolean)this.getEntityData().get(MOUTH_OPEN);
    }
}

