/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity;

import com.lovetropics.extras.entity.ExtraEntities;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class CleaningItemFrame
extends ItemFrame {
    private static final String CLEAN_TIME = "clean_time";
    private static final String MAX_CLEAN_TIME = "max_clean_time";
    private static final String CLEANED_ITEM = "cleaned_item";
    private static final String CLEANING_ITEM_PREDICATE = "cleaning_item_predicate";
    private static final String AUTOMATED = "automated";
    private static final EntityDataAccessor<Integer> DATA_CLEAN_TICK = SynchedEntityData.defineId(CleaningItemFrame.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_MAX_CLEAN_TICK = SynchedEntityData.defineId(CleaningItemFrame.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final ItemPredicate DEFAULT_PREDICATE = ItemPredicate.Builder.item().build();
    private boolean automated = false;
    private ItemStack cleanedItemOutput = ItemStack.EMPTY;
    private ItemPredicate cleaningItemPredicate = DEFAULT_PREDICATE;

    public CleaningItemFrame(EntityType<? extends ItemFrame> entityType, Level level) {
        super(entityType, level);
    }

    private CleaningItemFrame(EntityType<? extends ItemFrame> entityType, Level level, BlockPos pos, Direction direction) {
        super(entityType, level, pos, direction);
    }

    public static CleaningItemFrame create(Level level, BlockPos pos, Direction direction) {
        return new CleaningItemFrame((EntityType<? extends ItemFrame>)((EntityType)ExtraEntities.CLEANING_ITEM_FRAME.get()), level, pos, direction);
    }

    public void tick() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ItemStack itemInFrame = this.getItem();
            if (itemInFrame.is(this.cleanedItemOutput.getItem())) {
                return;
            }
            if (!this.cleaningItemPredicate.test(itemInFrame) || itemInFrame.isEmpty()) {
                this.setCleanTick(0);
                return;
            }
            if (this.automated) {
                this.processCleanTick(level2);
            }
        }
        super.tick();
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        Level level;
        if (hand == InteractionHand.MAIN_HAND && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack itemInFrame = this.getItem();
            if (!itemInFrame.isEmpty()) {
                if (!this.automated) {
                    this.processCleanTick(serverLevel);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            ItemStack stackInHand = player.getItemInHand(hand);
            if (this.cleaningItemPredicate.test(stackInHand) && !stackInHand.isEmpty()) {
                this.setItem(stackInHand);
                stackInHand.consume(1, (LivingEntity)player);
                this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, (Entity)player);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void processCleanTick(ServerLevel serverLevel) {
        int maxCleanTick;
        ItemStack currentItem = this.getItem();
        if (currentItem.is(this.cleanedItemOutput.getItem())) {
            return;
        }
        int cleanTick = this.getCleanTick();
        if (cleanTick < (maxCleanTick = this.getMaxCleanTick())) {
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SPLASH.getType(), this.getX(), this.getY(), this.getZ(), 5, 0.0, 0.0, 0.0, 1.0);
            this.setCleanTick(cleanTick + 1);
        }
        if (cleanTick == maxCleanTick) {
            this.setItem(this.cleanedItemOutput.copy());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_CLEAN_TICK, (Object)0);
        builder.define(DATA_MAX_CLEAN_TICK, (Object)100);
    }

    public int getCleanTick() {
        return (Integer)this.entityData.get(DATA_CLEAN_TICK);
    }

    public void setCleanTick(int tick) {
        this.entityData.set(DATA_CLEAN_TICK, (Object)tick);
    }

    public int getMaxCleanTick() {
        return (Integer)this.entityData.get(DATA_MAX_CLEAN_TICK);
    }

    public void setMaxCleanTick(int tick) {
        this.entityData.set(DATA_MAX_CLEAN_TICK, (Object)tick);
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putInt(CLEAN_TIME, this.getCleanTick());
        valueOutput.putInt(MAX_CLEAN_TIME, this.getMaxCleanTick());
        valueOutput.store(CLEANED_ITEM, ItemStack.CODEC, (Object)this.cleanedItemOutput);
        valueOutput.store(CLEANING_ITEM_PREDICATE, ItemPredicate.CODEC, (Object)this.cleaningItemPredicate);
        valueOutput.putBoolean(AUTOMATED, this.automated);
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setCleanTick(valueInput.getInt(CLEAN_TIME).orElse(0));
        this.setMaxCleanTick(valueInput.getInt(MAX_CLEAN_TIME).orElse(100));
        this.cleanedItemOutput = valueInput.read(CLEANED_ITEM, ItemStack.CODEC).orElse(ItemStack.EMPTY);
        this.cleaningItemPredicate = valueInput.read(CLEANING_ITEM_PREDICATE, ItemPredicate.CODEC).orElse(DEFAULT_PREDICATE);
        this.automated = valueInput.getBooleanOr(AUTOMATED, false);
    }
}

