/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity;

import com.lovetropics.extras.effect.ExtraEffects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.event.EventHooks;

public class FallingPropagule
extends AbstractHurtingProjectile {
    public FallingPropagule(EntityType<? extends AbstractHurtingProjectile> type, Level level) {
        super(type, level);
    }

    public boolean shouldBurn() {
        return false;
    }

    protected double getDefaultGravity() {
        return 0.005f;
    }

    public void tick() {
        super.tick();
        this.applyGravity();
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            boolean flag = EventHooks.canEntityGrief((ServerLevel)serverlevel, (Entity)this.getOwner());
            serverlevel.explode((Entity)this, this.getX(), this.getY(), this.getZ(), 0.2f, flag, Level.ExplosionInteraction.MOB);
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            Entity hitEntity = result.getEntity();
            DamageSource source = this.damageSources().cactus();
            hitEntity.hurtServer(serverlevel, source, 6.0f);
            EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)hitEntity, (DamageSource)source);
            if (hitEntity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)hitEntity;
                livingEntity.addEffect(new MobEffectInstance(ExtraEffects.PROPAGULED, 200));
            }
        }
    }
}

