/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity;

import com.lovetropics.extras.ExtraItems;
import com.lovetropics.extras.ExtraLangKeys;
import com.lovetropics.extras.client.keybinds.ForkliftKeybinds;
import com.lovetropics.extras.client.particle.ExtraParticles;
import com.lovetropics.extras.entity.ExtraSerializers;
import com.lovetropics.extras.network.message.ServerboundDriftForkliftPacket;
import com.lovetropics.extras.network.message.ServerboundLiftForkliftPacket;
import com.lovetropics.extras.sounds.ExtraSounds;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class ForkliftEntity
extends Entity
implements PlayerRideable {
    private static final EntityDataAccessor<Integer> DATA_FORK_HEIGHT = SynchedEntityData.defineId(ForkliftEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_IS_DRIFTING = SynchedEntityData.defineId(ForkliftEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> SPEED_BOOST_TICKS = SynchedEntityData.defineId(ForkliftEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> SPEED_BOOST_STRENGTH = SynchedEntityData.defineId(ForkliftEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Optional<BlockPredicate>> DATA_COLLISION_PREDICATE = SynchedEntityData.defineId(ForkliftEntity.class, (EntityDataSerializer)((EntityDataSerializer)ExtraSerializers.BLOCK_PREDICATE.get()));
    private static final EntityDataAccessor<Optional<BlockPredicate>> DATA_SLOW_PREDICATE = SynchedEntityData.defineId(ForkliftEntity.class, (EntityDataSerializer)((EntityDataSerializer)ExtraSerializers.BLOCK_PREDICATE.get()));
    private static final EntityDataAccessor<Float> DATA_SLOW_MULTIPLIER = SynchedEntityData.defineId(ForkliftEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final Component CERTIFICATION_MISSING = ExtraLangKeys.FORKLIFT_CERTIFICATION_MISSING.get().withStyle(ChatFormatting.RED);
    private static final float DEFAULT_SPEED_BOOST_STRENGTH = 0.05f;
    private static final int MAX_PASSENGERS = 3;
    public static final int MIN_FORK_HEIGHT = 0;
    public static final int MAX_FORK_HEIGHT = 18;
    public static final int FORK_HEIGHT = 18;
    private static final float RIDER_X_OFFSET = 0.8f;
    private static final float RIDER_Z_OFFSET = 2.75f;
    public static final float FORKLIFT_SCALE = 2.4f;
    public static final double FRICTION = (double)0.85f;
    public static final double DRIFT_FRICTION = (double)0.9f;
    public static final int DRIFT_TICKS = 50;
    public int driftBuildTicks = 0;
    public int driftDuration = 0;
    public int driftCooldown = 0;
    public float driftStrength = 0.0f;
    private float deltaRotation;
    public int renderForkHeight;
    public int renderForkHeight0;
    public float wheelRot;
    public float lastWheelRot;
    public boolean shouldPickupEntities = true;
    private final InterpolationHandler interpolation = new InterpolationHandler((Entity)this, 3);
    private boolean requiresCertification;

    public ForkliftEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        if (passenger.is((Entity)this.getControllingPassenger())) {
            return super.getDismountLocationForPassenger(passenger);
        }
        return this.getPickupAABB().getCenter().add(0.0, (double)((float)(20 - this.getForkHeight()) / 16.0f * 2.4f), 0.0);
    }

    public AABB getPickupAABB() {
        Vec3 lookVec = this.getLookAngle();
        return this.getBoundingBox().move(lookVec.normalize().multiply(2.0, 2.0, 2.0));
    }

    private void pickupEntitiesInFront() {
        if (!this.level().isClientSide && this.hasControllingPassenger() && this.getPassengers().size() < 3 && this.getKnownMovement().lengthSqr() > 0.0) {
            Predicate<Entity> predicate = EntitySelector.NO_SPECTATORS.and(this::canCollideWith).and(p -> p != this.getControllingPassenger() && !p.isPassenger());
            List list = this.level().getEntities((Entity)this, this.getPickupAABB(), predicate);
            if (!list.isEmpty()) {
                for (Entity e : list) {
                    if (this.getForkHeight() < 15) {
                        e.hurtServer((ServerLevel)this.level(), this.damageSources().thorns((Entity)this), 1.0f);
                    }
                    e.startRiding((Entity)this);
                }
            }
        }
    }

    private boolean hasItem(Player player, Item item) {
        return player.getInventory().contains(p -> p.is(item));
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!this.level().isClientSide && !player.isShiftKeyDown()) {
            if (!this.requiresCertification || this.hasItem(player, ExtraItems.FORKLIFT_CERTIFICATION.asItem())) {
                player.startRiding((Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.sendSystemMessage(CERTIFICATION_MISSING, true);
            }
        }
        return !player.isPassengerOfSameVehicle((Entity)this) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        int riderIndex = this.getPassengers().indexOf(entity);
        float forkHeight = 2.4f * (float)this.getForkHeight() / 16.0f;
        float forkRiderOffset = 2.8f - forkHeight;
        float riderYRot = -this.getYRot() * ((float)Math.PI / 180);
        if (riderIndex == 1) {
            return new Vec3((double)-0.8f, (double)forkRiderOffset, 2.75).yRot(riderYRot);
        }
        if (riderIndex == 2) {
            return new Vec3((double)0.8f, (double)forkRiderOffset, 2.75).yRot(riderYRot);
        }
        return super.getPassengerAttachmentPoint(entity, dimensions, partialTick);
    }

    public boolean canCollideWith(Entity entity) {
        return entity.isPushable() || super.canCollideWith(entity) || entity instanceof FallingBlockEntity || entity instanceof PrimedTnt;
    }

    public boolean canBeCollidedWith(@Nullable Entity entity) {
        return true;
    }

    public boolean isPickable() {
        return true;
    }

    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        if (this.isRemoved()) {
            return true;
        }
        Entity entity = damageSource.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getAbilities().instabuild) {
                this.markHurt();
                this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, damageSource.getEntity());
                this.discard();
                return true;
            }
        }
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_FORK_HEIGHT, (Object)18);
        builder.define(DATA_IS_DRIFTING, (Object)false);
        builder.define(DATA_COLLISION_PREDICATE, Optional.empty());
        builder.define(SPEED_BOOST_TICKS, (Object)0);
        builder.define(SPEED_BOOST_STRENGTH, (Object)Float.valueOf(0.05f));
        builder.define(DATA_SLOW_PREDICATE, Optional.empty());
        builder.define(DATA_SLOW_MULTIPLIER, (Object)Float.valueOf(0.5f));
    }

    private void tryEject() {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new ServerboundLiftForkliftPacket(true, 0, this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void sendForkHeightFromClient(int height) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new ServerboundLiftForkliftPacket(false, height, this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void setForkHeight(int height) {
        this.entityData.set(DATA_FORK_HEIGHT, (Object)Mth.clamp((int)height, (int)0, (int)18));
    }

    public int getForkHeight() {
        return (Integer)this.entityData.get(DATA_FORK_HEIGHT);
    }

    public float getRenderForkHeight(float partialTick) {
        return partialTick == 1.0f ? (float)this.getForkHeight() : Mth.lerp((float)partialTick, (float)this.renderForkHeight0, (float)this.renderForkHeight);
    }

    public float getWheelRot(float partialTick) {
        return partialTick == 1.0f ? this.wheelRot : Mth.lerp((float)partialTick, (float)this.lastWheelRot, (float)this.wheelRot);
    }

    public void setDrifting(boolean drifting) {
        this.entityData.set(DATA_IS_DRIFTING, (Object)drifting);
    }

    public boolean isDrifting() {
        return (Boolean)this.entityData.get(DATA_IS_DRIFTING);
    }

    protected void readAdditionalSaveData(ValueInput input) {
        this.requiresCertification = input.read("RequiresCertification", (Codec)Codec.BOOL).orElse(false);
        this.driftDuration = input.read("DriftDuration", (Codec)Codec.INT).orElse(0);
        this.entityData.set(DATA_COLLISION_PREDICATE, (Object)input.read("CollisionPredicate", BlockPredicate.CODEC));
        this.entityData.set(SPEED_BOOST_TICKS, (Object)input.read("SpeedBoostTicks", (Codec)Codec.INT).orElse(0));
        this.entityData.set(SPEED_BOOST_STRENGTH, (Object)input.read("SpeedBoostStrength", (Codec)Codec.FLOAT).orElse(Float.valueOf(0.05f)));
        this.entityData.set(DATA_FORK_HEIGHT, (Object)input.read("ForkHeight", (Codec)Codec.INT).orElse(18));
        this.entityData.set(DATA_SLOW_PREDICATE, (Object)input.read("SlowPredicate", BlockPredicate.CODEC));
        this.entityData.set(DATA_SLOW_MULTIPLIER, (Object)input.read("SlowMultiplier", (Codec)Codec.FLOAT).orElse(Float.valueOf(0.5f)));
        this.shouldPickupEntities = input.read("ShouldPickupEntities", (Codec)Codec.BOOL).orElse(true);
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        output.putBoolean("RequiresCertification", this.requiresCertification);
        output.putInt("DriftDuration", this.driftDuration);
        output.storeNullable("CollisionPredicate", BlockPredicate.CODEC, (Object)((Optional)this.entityData.get(DATA_COLLISION_PREDICATE)).orElse(null));
        output.putInt("SpeedBoostTicks", ((Integer)this.entityData.get(SPEED_BOOST_TICKS)).intValue());
        output.putFloat("SpeedBoostStrength", ((Float)this.entityData.get(SPEED_BOOST_STRENGTH)).floatValue());
        output.putInt("ForkHeight", ((Integer)this.entityData.get(DATA_FORK_HEIGHT)).intValue());
        output.storeNullable("SlowPredicate", BlockPredicate.CODEC, (Object)((Optional)this.entityData.get(DATA_SLOW_PREDICATE)).orElse(null));
        output.putFloat("SlowMultiplier", ((Float)this.entityData.get(DATA_SLOW_MULTIPLIER)).floatValue());
        output.putBoolean("ShouldPickupEntities", this.shouldPickupEntities);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity passenger;
        Entity firstPassenger = this.getFirstPassenger();
        LivingEntity controllingPassenger = firstPassenger instanceof LivingEntity ? (passenger = (LivingEntity)firstPassenger) : null;
        return controllingPassenger;
    }

    protected boolean canAddPassenger(Entity passenger) {
        return this.getPassengers().size() < 3;
    }

    @Nullable
    public InterpolationHandler getInterpolation() {
        return this.interpolation;
    }

    public void tick() {
        ServerPlayer player;
        LivingEntity livingEntity;
        super.tick();
        this.interpolation.interpolate();
        this.renderForkHeight0 = this.renderForkHeight;
        this.renderForkHeight = this.getForkHeight();
        this.tickWheelRotation();
        if (this.isLocalInstanceAuthoritative()) {
            int speedBoostTicks;
            this.applyGravity();
            if (!this.isDrifting()) {
                this.applyFriction(0.85f);
            }
            if ((speedBoostTicks = ((Integer)this.entityData.get(SPEED_BOOST_TICKS)).intValue()) > 0) {
                this.entityData.set(SPEED_BOOST_TICKS, (Object)(--speedBoostTicks));
            }
            if (this.level().isClientSide) {
                if (this.isDrifting() && this.driftDuration == 0) {
                    ClientPacketDistributor.sendToServer((CustomPacketPayload)new ServerboundDriftForkliftPacket(false, this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.driftCooldown = 50;
                }
                if (this.driftDuration > 0) {
                    --this.driftDuration;
                }
                if (this.driftCooldown > 0) {
                    --this.driftCooldown;
                }
                this.controlForklift();
            }
        } else {
            this.setDeltaMovement(Vec3.ZERO);
        }
        if (this.isDrifting() && this.level().isClientSide) {
            this.spawnDriftingParticles();
        }
        if ((livingEntity = this.getControllingPassenger()) instanceof ServerPlayer && (player = (ServerPlayer)livingEntity).getLastClientInput().backward() && this.tickCount % 20 == 0) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)ExtraSounds.FORKLIFT_REVERSE.value(), this.getSoundSource());
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.shouldPickupEntities) {
            this.pickupEntitiesInFront();
        }
    }

    public void tickWheelRotation() {
        this.lastWheelRot = this.wheelRot;
        float yRotRad = this.getYRot() * ((float)Math.PI / 180);
        float forwardX = -Mth.sin((float)yRotRad);
        float forwardZ = Mth.cos((float)yRotRad);
        float signedSpeed = (float)(this.getDeltaMovement().x * (double)forwardX + this.getDeltaMovement().z * (double)forwardZ);
        this.wheelRot += Mth.clamp((float)signedSpeed, (float)-360.0f, (float)360.0f);
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    public float maxUpStep() {
        return 0.5f;
    }

    private void applyFriction(double friction) {
        Vec3 velocity = this.getDeltaMovement();
        this.setDeltaMovement(velocity.x * friction, velocity.y, velocity.z * friction);
        this.deltaRotation = (float)((double)this.deltaRotation * friction);
    }

    private void moveFork(int amt) {
        this.sendForkHeightFromClient(this.getForkHeight() + amt);
    }

    private void controlForklift() {
        LivingEntity livingEntity;
        if (this.isVehicle() && (livingEntity = this.getControllingPassenger()) instanceof LocalPlayer) {
            boolean buildingDrift;
            Optional blockPredicate;
            int speedBoostTicks;
            LocalPlayer localPlayer = (LocalPlayer)livingEntity;
            float f = 0.0f;
            boolean inputLeft = localPlayer.input.keyPresses.left();
            boolean inputRight = localPlayer.input.keyPresses.right();
            boolean inputUp = localPlayer.input.keyPresses.forward();
            boolean inputDown = localPlayer.input.keyPresses.backward();
            boolean liftUp = ForkliftKeybinds.RAISE_FORKLIFT.isDown();
            boolean liftDown = ForkliftKeybinds.LOWER_FORKLIFT.isDown();
            boolean drift = ForkliftKeybinds.DRIFT.isDown();
            boolean eject_riders = ForkliftKeybinds.EJECT_FORK_RIDERS.isDown();
            if (eject_riders && this.getForkHeight() > 0 && !liftDown) {
                this.tryEject();
            }
            if (liftUp) {
                this.moveFork(-1);
            }
            if (liftDown) {
                this.moveFork(1);
            }
            if (inputLeft) {
                this.deltaRotation -= 1.0f;
            }
            if (inputRight) {
                this.deltaRotation += 1.0f;
            }
            if (inputRight != inputLeft && !inputUp && !inputDown) {
                f += 0.005f;
            }
            this.setYRot(this.getYRot() + this.deltaRotation);
            if (inputUp) {
                f += 0.05f;
            }
            if (inputDown) {
                f -= 0.02f;
            }
            if ((speedBoostTicks = ((Integer)this.entityData.get(SPEED_BOOST_TICKS)).intValue()) > 0) {
                float speedBoostStrength = ((Float)this.entityData.get(SPEED_BOOST_STRENGTH)).floatValue();
                f += speedBoostStrength;
            }
            if ((blockPredicate = (Optional)this.entityData.get(DATA_SLOW_PREDICATE)).isPresent() && ((BlockPredicate)blockPredicate.get()).matches(new BlockInWorld((LevelReader)this.level(), this.getOnPos(), false))) {
                float slowMultiplier = ((Float)this.entityData.get(DATA_SLOW_MULTIPLIER)).floatValue();
                f *= slowMultiplier;
            }
            boolean bl = buildingDrift = this.driftCooldown == 0 && !this.isDrifting() && drift && (inputUp && inputRight || inputDown && inputRight || inputUp && inputLeft || inputDown && inputLeft);
            if (buildingDrift) {
                ++this.driftBuildTicks;
            } else {
                if (this.driftBuildTicks > 0 && !this.isDrifting() && this.driftCooldown == 0) {
                    ClientPacketDistributor.sendToServer((CustomPacketPayload)new ServerboundDriftForkliftPacket(true, this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.driftDuration = 50;
                    this.driftStrength = (float)this.driftBuildTicks / 50.0f;
                }
                this.driftBuildTicks = 0;
            }
            this.driftBuildTicks = Mth.clamp((int)this.driftBuildTicks, (int)0, (int)50);
            if (this.isDrifting()) {
                this.executeDrift(this.getDeltaMovement());
            } else {
                this.setDeltaMovement(this.getDeltaMovement().add((double)(Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180))) * f), 0.0, (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * f)));
            }
            if (this.isPassenger()) {
                localPlayer.connection.send((Packet)ServerboundMoveVehiclePacket.fromEntity((Entity)this));
            }
        }
    }

    private void executeDrift(Vec3 travelVector) {
        this.hasImpulse = true;
        if (travelVector.lengthSqr() > (double)1.0E-5f) {
            float xVelocity = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
            float zVelocity = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
            float boost = this.driftStrength / 10.0f;
            this.setDeltaMovement(this.getDeltaMovement().add((double)(-xVelocity * boost) * (double)0.9f, 0.0, (double)(zVelocity * boost) * (double)0.9f));
        }
    }

    protected void positionRider(Entity entity, Entity.MoveFunction callback) {
        super.positionRider(entity, callback);
        if (!entity.getType().is(EntityTypeTags.CAN_TURN_IN_BOATS)) {
            entity.setYRot(entity.getYRot() + this.deltaRotation);
            entity.setYHeadRot(entity.getYHeadRot() + this.deltaRotation);
            this.refreshAndClampRotationIfDriver(entity);
        }
    }

    public void onPassengerTurned(Entity entity) {
        this.refreshAndClampRotationIfDriver(entity);
    }

    protected void refreshAndClampRotationIfDriver(Entity entity) {
        entity.setYBodyRot(this.getYRot());
        float f = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
        float f1 = this.getControllingPassenger() == entity ? Mth.clamp((float)f, (float)-105.0f, (float)105.0f) : f;
        f = f1 - f;
        entity.yRotO += f;
        entity.setYRot(entity.getYRot() + f);
        entity.setYHeadRot(entity.getYRot());
    }

    public void spawnDriftingParticles() {
        double yawRad = Math.toRadians(this.getYRot());
        double forwardX = -Math.sin(yawRad);
        double forwardZ = Math.cos(yawRad);
        double perpX = Math.cos(yawRad);
        double perpZ = Math.sin(yawRad);
        double baseX = this.getX();
        double baseY = this.getY() + 0.2;
        double baseZ = this.getZ();
        double intensity = 1.0 + (double)this.driftStrength * 2.0;
        for (int i = 0; i < 2; ++i) {
            double sideOffset = i == 0 ? -0.7 : 0.7;
            double px = baseX + forwardX * -1.2 + perpX * sideOffset;
            double pz = baseZ + forwardZ * -1.2 + perpZ * sideOffset;
            double vx = -this.getDeltaMovement().x * 0.5 + (this.level().random.nextDouble() - 0.5) * 0.02;
            double vz = -this.getDeltaMovement().z * 0.5 + (this.level().random.nextDouble() - 0.5) * 0.02;
            this.level().addParticle((ParticleOptions)ExtraParticles.FORK_LIFT_DRIFT_PARTICLE.get(), px, baseY, pz, vx * intensity, 0.02, vz * intensity);
        }
    }

    public void destroyBlock(BlockState state, Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION.getType(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1, 0.5, 0.5, 0.5, 0.1);
        }
    }

    public boolean shouldDestroyBlock(BlockPos pos, BlockState state) {
        return ((Optional)this.entityData.get(DATA_COLLISION_PREDICATE)).map(blockPredicate -> blockPredicate.matches(new BlockInWorld((LevelReader)this.level(), pos, false))).orElse(false);
    }

    public void applySpeedBoost(int ticks) {
        this.entityData.set(SPEED_BOOST_TICKS, (Object)ticks);
    }

    public final ItemStack getPickResult() {
        return new ItemStack((ItemLike)ExtraItems.FORKLIFT_SPAWN_EGG.get());
    }
}

