/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity;

import com.lovetropics.extras.ExtraBlocks;
import com.lovetropics.extras.ExtraTags;
import com.lovetropics.extras.entity.ExtraEntities;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class PrimedPlumbersTnt
extends PrimedTnt {
    private static final BlockState DEFAULT_BLOCK_STATE = ExtraBlocks.PLUMBERS_TNT.getDefaultState();
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.defineId(PrimedPlumbersTnt.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<BlockState> DATA_BLOCK_STATE_ID = SynchedEntityData.defineId(PrimedPlumbersTnt.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    private static final ExplosionDamageCalculator DAMAGE_CALCULATOR = new ExplosionDamageCalculator(){

        public boolean shouldBlockExplode(Explosion explosion, BlockGetter level, BlockPos pos, BlockState state, float power) {
            return state.is(ExtraTags.Blocks.PLUMBERS_TNT_EXPLODES) || state.is((Block)ExtraBlocks.PLUMBERS_TNT.get());
        }

        public Optional<Float> getBlockExplosionResistance(Explosion explosion, BlockGetter level, BlockPos pos, BlockState state, FluidState fluidState) {
            if (state.is(Blocks.WATER)) {
                return Optional.empty();
            }
            return state.is(Blocks.NETHER_PORTAL) ? Optional.empty() : super.getBlockExplosionResistance(explosion, level, pos, state, fluidState);
        }
    };
    @Nullable
    private EntityReference<LivingEntity> owner;
    private float explosionPower = 4.0f;

    public PrimedPlumbersTnt(EntityType<? extends PrimedPlumbersTnt> type, Level level) {
        super(type, level);
    }

    public static PrimedPlumbersTnt create(Level level, double x, double y, double z, @Nullable LivingEntity optionalOwner) {
        PrimedPlumbersTnt primed = new PrimedPlumbersTnt((EntityType<? extends PrimedPlumbersTnt>)((EntityType)ExtraEntities.PRIMED_PLUMBERS_TNT.get()), level);
        primed.setPos(x, y, z);
        double d0 = level.random.nextDouble() * 6.2831854820251465;
        primed.setDeltaMovement(-Math.sin(d0) * 0.02, 0.2, -Math.cos(d0) * 0.02);
        primed.setFuse(80);
        primed.xo = x;
        primed.yo = y;
        primed.zo = z;
        primed.owner = optionalOwner != null ? new EntityReference((UniquelyIdentifyable)optionalOwner) : null;
        return primed;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FUSE_ID, (Object)80);
        builder.define(DATA_BLOCK_STATE_ID, (Object)DEFAULT_BLOCK_STATE);
    }

    public void setBlockState(BlockState blockState) {
        this.entityData.set(DATA_BLOCK_STATE_ID, (Object)blockState);
    }

    public BlockState getBlockState() {
        return (BlockState)this.entityData.get(DATA_BLOCK_STATE_ID);
    }

    public void setFuse(int life) {
        this.entityData.set(DATA_FUSE_ID, (Object)life);
    }

    public int getFuse() {
        return (Integer)this.entityData.get(DATA_FUSE_ID);
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.setFuse(input.getShortOr("fuse", (short)80));
        this.explosionPower = input.getFloatOr("ExplosionPower", 0.0f);
        this.setBlockState(input.read("block_state", BlockState.CODEC).orElse(DEFAULT_BLOCK_STATE));
        this.owner = EntityReference.read((ValueInput)input, (String)"owner");
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putShort("fuse", (short)this.getFuse());
        output.putFloat("ExplosionPower", this.explosionPower);
        output.store("block_state", BlockState.CODEC, (Object)this.getBlockState());
        EntityReference.store(this.owner, (ValueOutput)output, (String)"owner");
    }

    protected void explode() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            serverlevel.explode((Entity)this, Explosion.getDefaultDamageSource((Level)serverlevel, (Entity)this), DAMAGE_CALCULATOR, this.getX(), this.getY(0.0625), this.getZ(), this.explosionPower, false, Level.ExplosionInteraction.TNT);
        }
    }
}

