/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity;

import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SpinningSignEntity
extends Entity {
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.defineId(SpinningSignEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Optional<Component>> DATA_TEXT = SynchedEntityData.defineId(SpinningSignEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_COMPONENT);
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.defineId(SpinningSignEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);

    public SpinningSignEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_SCALE, (Object)Float.valueOf(1.0f));
        builder.define(DATA_TEXT, Optional.empty());
        builder.define(DATA_ITEM, (Object)ItemStack.EMPTY);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (DATA_SCALE.equals(key)) {
            this.refreshDimensions();
        }
    }

    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        return false;
    }

    protected void readAdditionalSaveData(ValueInput input) {
        this.entityData.set(DATA_SCALE, (Object)Float.valueOf(input.getFloatOr("Scale", 1.0f)));
        this.entityData.set(DATA_TEXT, (Object)input.read("Text", ComponentSerialization.CODEC));
        this.entityData.set(DATA_ITEM, (Object)input.read("Item", ItemStack.CODEC).orElse(ItemStack.EMPTY));
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        output.putFloat("Scale", ((Float)this.entityData.get(DATA_SCALE)).floatValue());
        output.storeNullable("Text", ComponentSerialization.CODEC, (Object)((Optional)this.entityData.get(DATA_TEXT)).orElse(null));
        ItemStack item = (ItemStack)this.entityData.get(DATA_ITEM);
        if (!item.isEmpty()) {
            output.store("Item", ItemStack.CODEC, (Object)item);
        }
    }

    public boolean canBeCollidedWith(@Nullable Entity entity) {
        return false;
    }

    public boolean canCollideWith(Entity entity) {
        return false;
    }

    public float getScale() {
        return ((Float)this.getEntityData().get(DATA_SCALE)).floatValue();
    }

    public Optional<Component> getText() {
        return (Optional)this.entityData.get(DATA_TEXT);
    }

    public ItemStack getItem() {
        return (ItemStack)this.entityData.get(DATA_ITEM);
    }

    public boolean isPickable() {
        return false;
    }

    protected AABB makeBoundingBox(Vec3 position) {
        float sizeXZ = this.getScale() * 3.35f;
        float sizeY = this.getScale() * 0.75f;
        return AABB.ofSize((Vec3)position, (double)sizeXZ, (double)sizeY, (double)sizeXZ);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }
}

