/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity;

import com.lovetropics.extras.ExtraItems;
import com.lovetropics.extras.ExtraLangKeys;
import com.lovetropics.extras.effect.ExtraEffects;
import com.lovetropics.extras.model_modifer.ModelModifierType;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WaterCoolerEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_SHAKE_TIME = SynchedEntityData.defineId(WaterCoolerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> SHAKE_TYPE = SynchedEntityData.defineId(WaterCoolerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final RandomSource random = RandomSource.create();
    private static final ModelModifierType[] MODIFIER_TYPES = new ModelModifierType[]{ModelModifierType.FABULOUS, ModelModifierType.FLAIL, ModelModifierType.HOVERING, ModelModifierType.SHUFFLE, ModelModifierType.UPSIDEDOWN, ModelModifierType.SHRUNK, ModelModifierType.ENLARGED, ModelModifierType.SHRUGGY_ARMS, ModelModifierType.ENDER_ARMS};
    public final AnimationState shake1AnimationState = new AnimationState();
    public final AnimationState shake2AnimationState = new AnimationState();
    public final AnimationState shake3AnimationState = new AnimationState();
    public final AnimationState shakeDispenseAnimationState = new AnimationState();

    public WaterCoolerEntity(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_SHAKE_TIME, (Object)0);
        builder.define(SHAKE_TYPE, (Object)0);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.setupAnimationStates();
        }
        if (this.isShaking()) {
            this.entityData.set(DATA_SHAKE_TIME, (Object)(this.getShakeTime() - 1));
        }
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float v) {
        return false;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (!this.isShaking()) {
            if (random.nextInt(100) >= 90) {
                this.dispense(this.level());
            } else {
                this.shake();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void shake() {
        int random = this.getRandom().nextInt(3);
        this.entityData.set(SHAKE_TYPE, (Object)random);
        this.entityData.set(DATA_SHAKE_TIME, (Object)5);
    }

    public void dispense(Level level) {
        this.entityData.set(SHAKE_TYPE, (Object)3);
        this.entityData.set(DATA_SHAKE_TIME, (Object)6);
        ItemEntity itemEntity = new ItemEntity(level, this.getX(), this.getY() + 1.25, this.getZ(), WaterCoolerEntity.getPotionDrop());
        level.addFreshEntity((Entity)itemEntity);
    }

    private void setupAnimationStates() {
        int shakeType = (Integer)this.entityData.get(SHAKE_TYPE);
        this.shake1AnimationState.animateWhen(shakeType == 0 && this.isShaking(), this.tickCount);
        this.shake2AnimationState.animateWhen(shakeType == 1 && this.isShaking(), this.tickCount);
        this.shake3AnimationState.animateWhen(shakeType == 2 && this.isShaking(), this.tickCount);
        this.shakeDispenseAnimationState.animateWhen(shakeType == 3 && this.isShaking(), this.tickCount);
    }

    protected void readAdditionalSaveData(ValueInput input) {
        this.entityData.set(DATA_SHAKE_TIME, (Object)input.getIntOr("shake_time", 0));
        this.entityData.set(SHAKE_TYPE, (Object)input.getIntOr("shake_type", 0));
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        output.putInt("shake_time", this.getShakeTime());
        output.putInt("shake_type", ((Integer)this.entityData.get(SHAKE_TYPE)).intValue());
    }

    public boolean canBeCollidedWith(@Nullable Entity entity) {
        return false;
    }

    public int getShakeTime() {
        return (Integer)this.getEntityData().get(DATA_SHAKE_TIME);
    }

    public boolean isShaking() {
        return this.getShakeTime() > 0;
    }

    private static ItemStack getPotionDrop() {
        MobEffectInstance mobEffect = new MobEffectInstance((Holder)ExtraEffects.MODEL_EFFECTS.get(Util.getRandom((Object[])MODIFIER_TYPES, (RandomSource)random)), 300, 1);
        PotionContents potionContents = new PotionContents(Optional.empty(), Optional.of(5934550), List.of(), Optional.of(ExtraLangKeys.WATER_COOLER_POTION_NAME.get().toString())).withEffectAdded(mobEffect);
        ItemStack itemStack = new ItemStack((ItemLike)Items.POTION, 1);
        itemStack.set(DataComponents.POTION_CONTENTS, (Object)potionContents);
        itemStack.set(DataComponents.CUSTOM_NAME, (Object)ExtraLangKeys.WATER_COOLER_POTION_NAME.get());
        itemStack.set(DataComponents.LORE, (Object)ItemLore.EMPTY.withLineAdded((Component)ExtraLangKeys.WATER_COOLER_POTION_LORE.get().withColor(ChatFormatting.GRAY.getColor().intValue())));
        itemStack.set(DataComponents.TOOLTIP_DISPLAY, (Object)TooltipDisplay.DEFAULT.withHidden(DataComponents.ATTRIBUTE_MODIFIERS, true).withHidden(DataComponents.POTION_CONTENTS, true));
        return itemStack;
    }

    protected AABB makeBoundingBox(Vec3 position) {
        return AABB.ofSize((Vec3)position.add(new Vec3(0.0, (double)0.65f, 0.0)), (double)0.75, (double)1.75, (double)0.75);
    }

    public final ItemStack getPickResult() {
        return new ItemStack((ItemLike)ExtraItems.WATER_COOLER_SPAWN_EGG.get());
    }

    public boolean isPickable() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }
}

