/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity.glass_frog;

import com.google.common.collect.ImmutableMap;
import com.lovetropics.extras.entity.glass_frog.GlassFrog;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class GlassCroak
extends Behavior<GlassFrog> {
    private static final int CROAK_TICKS = 60;
    private static final int TIME_OUT_DURATION = 100;
    private int croakCounter;

    public GlassCroak() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), 100);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, GlassFrog glassFrog) {
        return glassFrog.getPose() == Pose.STANDING;
    }

    protected boolean canStillUse(ServerLevel level, GlassFrog glassFrog, long gameTime) {
        return this.croakCounter < 60;
    }

    protected void start(ServerLevel level, GlassFrog glassFrog, long gameTime) {
        if (!glassFrog.isInLiquid()) {
            glassFrog.setPose(Pose.CROAKING);
            this.croakCounter = 0;
        }
    }

    protected void stop(ServerLevel level, GlassFrog glassFrog, long gameTime) {
        glassFrog.setPose(Pose.STANDING);
    }

    protected void tick(ServerLevel level, GlassFrog glassFrog, long gameTime) {
        ++this.croakCounter;
    }
}

