/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity.glass_frog;

import com.google.common.collect.ImmutableList;
import com.lovetropics.extras.entity.ExtraEntities;
import com.lovetropics.extras.entity.glass_frog.GlassFrogAi;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.Vec3;

public class GlassFrog
extends Animal {
    protected static final ImmutableList<SensorType<? extends Sensor<? super GlassFrog>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)SensorType.FROG_TEMPTATIONS, (Object)SensorType.IS_IN_WATER);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)MemoryModuleType.LONG_JUMP_MID_JUMP, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object[])new MemoryModuleType[]{MemoryModuleType.IS_TEMPTED, MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.NEAREST_ATTACKABLE, MemoryModuleType.IS_IN_WATER, MemoryModuleType.IS_PANICKING});
    public int jumpDelay = 0;

    public GlassFrog(EntityType<? extends GlassFrog> type, Level level) {
        super(type, level);
        this.setPathfindingMalus(PathType.WATER, 4.0f);
        this.setPathfindingMalus(PathType.TRAPDOOR, -1.0f);
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MOVEMENT_SPEED, 2.5).add(Attributes.MAX_HEALTH, 4.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.FROG_FOOD);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        GlassFrog frog = (GlassFrog)ExtraEntities.GLASS_FROG.create((Level)level, EntitySpawnReason.BREEDING);
        if (frog != null) {
            GlassFrogAi.initMemories(frog, level.getRandom());
        }
        return frog;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        GlassFrogAi.initMemories(this, levelAccessor.getRandom());
        return super.finalizeSpawn(levelAccessor, difficultyInstance, spawnReason, spawnGroupData);
    }

    protected int calculateFallDamage(double fallDistance, float damageMultiplier) {
        return super.calculateFallDamage(fallDistance, damageMultiplier) - 5;
    }

    protected Brain.Provider<GlassFrog> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> ops) {
        return GlassFrogAi.makeBrain((Brain<GlassFrog>)this.brainProvider().makeBrain(ops));
    }

    public Brain<GlassFrog> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep(ServerLevel level) {
        this.getBrain().tick(level, (LivingEntity)this);
        GlassFrogAi.updateActivity(this);
        super.customServerAiStep(level);
        if (!(this.getNavigation().isDone() && this.getTarget() == null || !this.onGround() && !this.isInWater())) {
            if (this.jumpDelay > 0) {
                --this.jumpDelay;
            }
            if (this.jumpDelay <= 0) {
                this.jumpDelay = 5 + this.random.nextInt(4);
                Vec3 motion = this.getDeltaMovement();
                if (motion.horizontalDistanceSqr() > 4.0E-4) {
                    double motionY = motion.y + 0.3;
                    double motionX = motion.x * 1.1;
                    double motionZ = motion.z * 1.1;
                    this.setDeltaMovement(motionX, motionY, motionZ);
                }
            }
        }
    }

    public int getHeadRotSpeed() {
        return 35;
    }

    public int getMaxHeadYRot() {
        return 5;
    }

    public void travel(Vec3 travelVector) {
        if (this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(travelVector);
        }
    }

    public boolean isPushedByFluid() {
        return false;
    }

    static class GlassFrogPathNavigation
    extends AmphibiousPathNavigation {
        GlassFrogPathNavigation(Frog mob, Level level) {
            super((Mob)mob, level);
        }

        public boolean canCutCorner(PathType pathType) {
            return pathType != PathType.WATER_BORDER && super.canCutCorner(pathType);
        }

        protected PathFinder createPathFinder(int p_218559_) {
            this.nodeEvaluator = new GlassFrogNodeEvaluator(true);
            return new PathFinder(this.nodeEvaluator, p_218559_);
        }
    }

    static class GlassFrogNodeEvaluator
    extends AmphibiousNodeEvaluator {
        private final BlockPos.MutableBlockPos belowPos = new BlockPos.MutableBlockPos();

        public GlassFrogNodeEvaluator(boolean p_218548_) {
            super(p_218548_);
        }

        public Node getStart() {
            return !this.mob.isInWater() ? super.getStart() : this.getStartNode(new BlockPos(Mth.floor((double)this.mob.getBoundingBox().minX), Mth.floor((double)this.mob.getBoundingBox().minY), Mth.floor((double)this.mob.getBoundingBox().minZ)));
        }

        public PathType getPathType(PathfindingContext context, int x, int y, int z) {
            this.belowPos.set(x, y - 1, z);
            BlockState blockstate = context.getBlockState((BlockPos)this.belowPos);
            return blockstate.is(BlockTags.FROG_PREFER_JUMP_TO) ? PathType.OPEN : super.getPathType(context, x, y, z);
        }
    }
}

