/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity.glass_frog;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.lovetropics.extras.entity.ExtraEntities;
import com.lovetropics.extras.entity.glass_frog.GlassCroak;
import com.lovetropics.extras.entity.glass_frog.GlassFrog;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LongJumpMidJump;
import net.minecraft.world.entity.ai.behavior.LongJumpToPreferredBlock;
import net.minecraft.world.entity.ai.behavior.LongJumpToRandomPos;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.TryFindLand;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class GlassFrogAi {
    private static final UniformInt TIME_BETWEEN_LONG_JUMPS = UniformInt.of((int)100, (int)140);

    protected static void initMemories(GlassFrog frog, RandomSource random) {
        frog.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)TIME_BETWEEN_LONG_JUMPS.sample(random));
    }

    protected static Brain<?> makeBrain(Brain<GlassFrog> brain) {
        GlassFrogAi.initCoreActivity(brain);
        GlassFrogAi.initIdleActivity(brain);
        GlassFrogAi.initSwimActivity(brain);
        GlassFrogAi.initJumpActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<GlassFrog> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(Brain<GlassFrog> brain) {
        brain.addActivityWithConditions(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)0, (Object)new AnimalMakeLove((EntityType)ExtraEntities.GLASS_FROG.get())), (Object)Pair.of((Object)1, (Object)new FollowTemptation(livingEntity -> Float.valueOf(1.25f))), (Object)Pair.of((Object)2, (Object)StartAttacking.create((level, frog) -> GlassFrogAi.canAttack(frog), (level, frog) -> frog.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE))), (Object)Pair.of((Object)3, (Object)TryFindLand.create((int)6, (float)1.0f)), (Object)Pair.of((Object)4, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)((Object)new GlassCroak()), (Object)3), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(Entity::onGround), (Object)2))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.LONG_JUMP_MID_JUMP, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.IS_IN_WATER, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void initSwimActivity(Brain<GlassFrog> brain) {
        brain.addActivityWithConditions(Activity.SWIM, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new FollowTemptation(livingEntity -> Float.valueOf(1.25f))), (Object)Pair.of((Object)2, (Object)StartAttacking.create((level, frog) -> GlassFrogAi.canAttack(frog), (level, frog) -> frog.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE))), (Object)Pair.of((Object)3, (Object)TryFindLand.create((int)8, (float)1.5f)), (Object)Pair.of((Object)5, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.swim((float)0.75f), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)1.0f, (boolean)true), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(Entity::isInWater), (Object)5))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.LONG_JUMP_MID_JUMP, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.IS_IN_WATER, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void initJumpActivity(Brain<GlassFrog> brain) {
        brain.addActivityWithConditions(Activity.LONG_JUMP, ImmutableList.of((Object)Pair.of((Object)0, (Object)new LongJumpMidJump(TIME_BETWEEN_LONG_JUMPS, SoundEvents.FROG_STEP)), (Object)Pair.of((Object)1, (Object)new LongJumpToPreferredBlock(TIME_BETWEEN_LONG_JUMPS, 2, 4, 3.5714288f, frog -> SoundEvents.FROG_LONG_JUMP, BlockTags.FROG_PREFER_JUMP_TO, 0.5f, GlassFrogAi::isAcceptableLandingSpot))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.BREED_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.IS_IN_WATER, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static <E extends Mob> boolean isAcceptableLandingSpot(E mob, BlockPos pos) {
        Level level = mob.level();
        BlockPos blockpos = pos.below();
        if (level.getFluidState(pos).isEmpty() && level.getFluidState(blockpos).isEmpty() && level.getFluidState(pos.above()).isEmpty()) {
            BlockState blockstate = level.getBlockState(pos);
            BlockState blockstate1 = level.getBlockState(blockpos);
            if (!blockstate.is(BlockTags.FROG_PREFER_JUMP_TO) && !blockstate1.is(BlockTags.FROG_PREFER_JUMP_TO)) {
                PathfindingContext pathfindingcontext = new PathfindingContext((CollisionGetter)mob.level(), mob);
                PathType pathtype = WalkNodeEvaluator.getPathTypeStatic((PathfindingContext)pathfindingcontext, (BlockPos.MutableBlockPos)pos.mutable());
                PathType pathtype1 = WalkNodeEvaluator.getPathTypeStatic((PathfindingContext)pathfindingcontext, (BlockPos.MutableBlockPos)blockpos.mutable());
                return pathtype != PathType.TRAPDOOR && (!blockstate.isAir() || pathtype1 != PathType.TRAPDOOR) ? LongJumpToRandomPos.defaultAcceptableLandingSpot(mob, (BlockPos)pos) : true;
            }
            return true;
        }
        return false;
    }

    private static boolean canAttack(GlassFrog frog) {
        return !BehaviorUtils.isBreeding((LivingEntity)frog);
    }

    public static void updateActivity(GlassFrog frog) {
        frog.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.LONG_JUMP, (Object)Activity.SWIM, (Object)Activity.IDLE));
    }

    public static Predicate<ItemStack> getTemptations() {
        return p_335267_ -> p_335267_.is(ItemTags.FROG_FOOD);
    }
}

