/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity.ravekoa;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class RaveKoaEntity
extends PathfinderMob {
    public final AnimationState raveAnimationStateDJ = new AnimationState();
    public final AnimationState raveAnimationStateDance1 = new AnimationState();
    public final AnimationState raveAnimationStateDance2 = new AnimationState();

    public RaveKoaEntity(EntityType<? extends RaveKoaEntity> type, Level world) {
        super(type, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isInvulnerable() {
        return true;
    }

    public boolean isInvulnerableTo(ServerLevel level, DamageSource source) {
        return !source.isCreativePlayer() && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        this.setPersistenceRequired();
        return super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public void checkDespawn() {
    }
}

