/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.entity.vfx;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ARGB;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import org.joml.Vector3f;

@EventBusSubscriber(modid="ltextras")
public class PartyBeamEntity
extends EndCrystal {
    private static final EntityDataAccessor<Vector3f> DATA_COLOR = SynchedEntityData.defineId(PartyBeamEntity.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    @Nullable
    private BlockPos targetPos = null;

    public PartyBeamEntity(EntityType<? extends EndCrystal> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.targetPos != null && this.level().getGameTime() % 100L == 0L) {
            this.random.setSeed(this.level().getGameTime());
            int ax = this.targetPos.getX() + (this.random.nextInt(5) - this.random.nextInt(5));
            int az = this.targetPos.getZ() + (this.random.nextInt(5) - this.random.nextInt(5));
            int packed = Mth.hsvToRgb((float)this.random.nextFloat(), (float)0.8f, (float)0.8f);
            int r = ARGB.red((int)packed);
            int g = ARGB.green((int)packed);
            int b = ARGB.blue((int)packed);
            this.setColor(new Vector3f((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f));
            this.setBeamTarget(new BlockPos(ax, this.targetPos.getY(), az));
        }
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.storeNullable("TargetPos", BlockPos.CODEC, (Object)this.targetPos);
        output.store("TargetColor", ExtraCodecs.VECTOR3F, (Object)this.getColor());
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.targetPos = input.read("TargetPos", BlockPos.CODEC).orElse(null);
        this.setColor(input.read("TargetColor", ExtraCodecs.VECTOR3F).orElse(new Vector3f()));
    }

    public void setColor(Vector3f color) {
        this.getEntityData().set(DATA_COLOR, (Object)color);
    }

    public Vector3f getColor() {
        return (Vector3f)this.getEntityData().get(DATA_COLOR);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_COLOR, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
    }

    @SubscribeEvent
    public static void onExplosionStart(ExplosionEvent.Start event) {
        if (event.getExplosion().getDirectSourceEntity() instanceof PartyBeamEntity) {
            event.setCanceled(true);
        }
    }
}

