/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.item;

import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.ExtraLangKeys;
import com.lovetropics.extras.collectible.Collectible;
import com.lovetropics.extras.collectible.CollectibleStore;
import com.lovetropics.extras.entity.CollectibleEntity;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CollectibleCompassItem
extends Item {
    private static final String ENTITY_TAG_IGNORE = "compass_hidden";
    private static final int COOLDOWN_TICKS = 100;
    private static final double SEARCH_RANGE = 80.0;

    public CollectibleCompassItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        player.getCooldowns().addCooldown(stack, 100);
        if (stack.has(ExtraDataComponents.COLLECTIBLE_TARGET)) {
            serverPlayer.sendSystemMessage((Component)ExtraLangKeys.COLLECTIBLE_COMPASS_ALREADY_USED.get().withStyle(ChatFormatting.RED));
            return InteractionResult.FAIL;
        }
        Target target = CollectibleCompassItem.tryLocateCollectible(level, player);
        if (target != null) {
            stack.set(ExtraDataComponents.COLLECTIBLE_TARGET, (Object)target);
            serverPlayer.sendSystemMessage((Component)ExtraLangKeys.COLLECTIBLE_COMPASS_SUCCESS.get().withStyle(ChatFormatting.GOLD));
        } else {
            serverPlayer.sendSystemMessage((Component)ExtraLangKeys.COLLECTIBLE_COMPASS_FAIL.get().withStyle(ChatFormatting.RED));
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    private static Target tryLocateCollectible(Level level, Player player) {
        CollectibleStore collectibles = CollectibleStore.get(player);
        List candidates = level.getEntitiesOfClass(CollectibleEntity.class, player.getBoundingBox().inflate(80.0), entity -> {
            if (entity.getTags().contains(ENTITY_TAG_IGNORE)) {
                return false;
            }
            Holder<Collectible> collectible = entity.getCollectible();
            return collectible != null && !collectibles.contains(collectible);
        });
        return Util.getRandomSafe((List)candidates, (RandomSource)player.getRandom()).map(entity -> new Target(GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)entity.blockPosition()), entity.getUUID())).orElse(null);
    }

    public boolean isFoil(ItemStack stack) {
        return stack.has(ExtraDataComponents.COLLECTIBLE_TARGET);
    }

    public record Target(GlobalPos pos, UUID id) {
        public static final Codec<Target> CODEC = RecordCodecBuilder.create(i -> i.group((App)GlobalPos.CODEC.fieldOf("pos").forGetter(Target::pos), (App)UUIDUtil.CODEC.fieldOf("id").forGetter(Target::id)).apply((Applicative)i, Target::new));
        public static final StreamCodec<ByteBuf, Target> STREAM_CODEC = StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, Target::pos, (StreamCodec)UUIDUtil.STREAM_CODEC, Target::id, Target::new);
    }
}

