/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.item;

import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.block.entity.MobControllerBlockEntity;
import com.lovetropics.extras.entity.ExtendedCreatureEntity;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EntityWandItem
extends Item {
    public EntityWandItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (player.level().isClientSide()) {
            return super.interactLivingEntity(stack, player, target, hand);
        }
        if (target instanceof ExtendedCreatureEntity) {
            ItemStack heldItem = player.getItemInHand(hand);
            heldItem.set(ExtraDataComponents.TARGETED_ENTITY, (Object)target.getUUID());
            player.displayClientMessage((Component)Component.literal((String)"Targeted entity!"), true);
            return InteractionResult.SUCCESS;
        }
        player.displayClientMessage((Component)Component.literal((String)"This entity cannot be targeted!"), true);
        return super.interactLivingEntity(stack, player, target, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return super.useOn(context);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos pos = context.getClickedPos();
        ItemStack stack = context.getItemInHand();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MobControllerBlockEntity) {
            Entity entity;
            MobControllerBlockEntity mobController = (MobControllerBlockEntity)blockEntity;
            UUID entityId = (UUID)stack.get(ExtraDataComponents.TARGETED_ENTITY);
            if (entityId != null && (entity = serverLevel.getEntity(entityId)) != null) {
                mobController.addEntity(entity);
                context.getPlayer().displayClientMessage((Component)Component.literal((String)"Added entity!"), true);
            }
        }
        return super.useOn(context);
    }
}

