/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.item;

import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.item.FireExtinguisher;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FireExtinguisherItem
extends BlockItem {
    public static final int DEFAULT_SHOOT_DIST = 12;
    public static final float DEFAULT_IMPULSE_ON_HIT = 0.25f;
    public static final float DEFAULT_IMPULSE_ON_MISS = 0.05f;
    public static final float SPRAY = 6.0f;
    public static final int HOW_FAR_IN_FRONT_TO_SHOOT_FROM = 2;

    public FireExtinguisherItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResult.SUCCESS;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        float scale;
        FireExtinguisher extinguisherComponent = (FireExtinguisher)stack.getOrDefault(ExtraDataComponents.FIRE_EXTINGUISHER, (Object)FireExtinguisher.getDefault());
        Vec3 pos = livingEntity.getEyePosition();
        Vec3 lookVec = livingEntity.getLookAngle();
        Vec3 startPos = livingEntity.getLookAngle().scale(2.0);
        boolean hit = false;
        for (int i = -5; i < 5; ++i) {
            BlockPos above;
            BlockState aboveState;
            double xSpeed = lookVec.x + (double)((float)i / 6.0f);
            double zSpeed = lookVec.z + (double)((float)i / 6.0f);
            double xLoc = pos.x + startPos.x + (double)level.random.triangle(0.0f, 1.0f);
            double zLoc = pos.z + startPos.z + (double)level.random.triangle(0.0f, 1.0f);
            if (level.isClientSide) {
                level.addParticle((ParticleOptions)ParticleTypes.CLOUD, true, true, xLoc, pos.y, zLoc, xSpeed, lookVec.y, zSpeed);
                if (i % 3 == 0) {
                    level.addParticle((ParticleOptions)ParticleTypes.SMOKE, true, true, xLoc, pos.y, zLoc, xSpeed, lookVec.y, zSpeed);
                }
            }
            Vec3 to = livingEntity.getViewVector(0.0f).scale((double)extinguisherComponent.shootDist());
            HitResult result = FireExtinguisherItem.getHitResultOnViewVector((Entity)livingEntity, to = to.add(xSpeed, 0.0, zSpeed), Entity::isPickable);
            if (result.getType() == HitResult.Type.MISS) continue;
            hit = true;
            if (level.isClientSide || !extinguisherComponent.shouldExtinguish()) continue;
            if (result instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)result;
                if (!entityHitResult.getEntity().isOnFire()) continue;
                entityHitResult.getEntity().extinguishFire();
                continue;
            }
            if (!(result instanceof BlockHitResult)) continue;
            BlockHitResult blockHitResult = (BlockHitResult)result;
            BlockPos hitPos = blockHitResult.getBlockPos();
            FluidState hitFluidState = level.getFluidState(hitPos);
            if (hitFluidState.is(FluidTags.LAVA)) {
                level.playSound(null, (double)hitPos.getX(), (double)hitPos.getY(), (double)hitPos.getZ(), SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.2f, 1.0f);
                level.setBlockAndUpdate(hitPos, Blocks.OBSIDIAN.defaultBlockState());
            }
            if ((aboveState = level.getBlockState(above = hitPos.above())).is(BlockTags.FIRE)) {
                level.destroyBlock(above, false, (Entity)livingEntity);
                continue;
            }
            if (AbstractCandleBlock.isLit((BlockState)aboveState)) {
                AbstractCandleBlock.extinguish(null, (BlockState)aboveState, (LevelAccessor)level, (BlockPos)above);
                continue;
            }
            if (!CampfireBlock.isLitCampfire((BlockState)aboveState)) continue;
            level.levelEvent(null, 1009, above, 0);
            CampfireBlock.dowse((Entity)livingEntity, (LevelAccessor)level, (BlockPos)above, (BlockState)aboveState);
            level.setBlockAndUpdate(above, (BlockState)aboveState.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
        float f = scale = hit ? extinguisherComponent.impulseOnHit() : extinguisherComponent.impulseOnMiss();
        if (livingEntity.getVehicle() != null && !level.isClientSide) {
            livingEntity.getVehicle().hasImpulse = true;
            livingEntity.getVehicle().setDeltaMovement(lookVec.reverse().scale((double)scale));
        } else if (level.isClientSide) {
            livingEntity.hasImpulse = true;
            livingEntity.setDeltaMovement(lookVec.reverse().scale((double)scale));
        } else {
            EquipmentSlot slot = stack.equals(livingEntity.getItemBySlot(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
            stack.hurtAndBreak(extinguisherComponent.durabilityLossPerTick(), livingEntity, slot);
        }
        if (livingEntity.tickCount % 2 == 0) {
            level.playSound((Entity)livingEntity, pos.x, pos.y, pos.z, SoundEvents.CANDLE_EXTINGUISH, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.isSecondaryUseActive()) {
            return super.useOn(context);
        }
        return InteractionResult.PASS;
    }

    private static HitResult getHitResultOnViewVector(Entity projectile, Vec3 to, Predicate<Entity> filter) {
        Level level = projectile.level();
        Vec3 from = projectile.getEyePosition();
        return FireExtinguisherItem.getHitResult(from, projectile, filter, to, level);
    }

    private static HitResult getHitResult(Vec3 from, Entity projectile, Predicate<Entity> filter, Vec3 to, Level level) {
        EntityHitResult hitresult1;
        Vec3 ray = from.add(to);
        BlockHitResult hitresult = level.clipIncludingBorder(new ClipContext(from, ray, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, projectile));
        if (hitresult.getType() != HitResult.Type.MISS) {
            ray = hitresult.getLocation();
        }
        if ((hitresult1 = ProjectileUtil.getEntityHitResult((Level)level, (Entity)projectile, (Vec3)from, (Vec3)ray, (AABB)projectile.getBoundingBox().expandTowards(to).inflate(1.0), filter, (float)0.0f)) != null) {
            hitresult = hitresult1;
        }
        return hitresult;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 999999;
    }
}

