/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.item;

import com.lovetropics.extras.ExtraItems;
import com.lovetropics.extras.entity.ExtraEntities;
import com.lovetropics.extras.entity.ForkliftEntity;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="ltextras")
public class ForkliftSpawnEggItem
extends Item {
    public ForkliftSpawnEggItem(Item.Properties properties) {
        super(properties);
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!event.getLevel().isClientSide) {
            Level level;
            Entity entity = event.getTarget();
            Player player = event.getEntity();
            ItemStack stack = event.getItemStack();
            InteractionHand hand = event.getHand();
            if (entity.getType() == ForkliftSpawnEggItem.getType() && (level = player.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (stack.getItem() == ExtraItems.FORKLIFT_SPAWN_EGG.asItem()) {
                    ForkliftEntity babyForklift = (ForkliftEntity)ForkliftSpawnEggItem.getType().spawn(serverLevel, stack, (LivingEntity)player, entity.blockPosition().above(6), EntitySpawnReason.SPAWN_ITEM_USE, false, false);
                    if (babyForklift != null) {
                        babyForklift.startRiding(entity);
                    }
                    player.awardStat(Stats.ITEM_USED.get((Object)ExtraItems.FORKLIFT_SPAWN_EGG.asItem()));
                    serverLevel.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, entity.position());
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    event.setCanceled(true);
                }
            }
        }
    }

    private static EntityType<ForkliftEntity> getType() {
        return (EntityType)ExtraEntities.FORKLIFT.get();
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult blockhitresult = ForkliftSpawnEggItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = blockhitresult.getBlockPos();
            if (!(level.getBlockState(pos).getBlock() instanceof LiquidBlock)) {
                return InteractionResult.PASS;
            }
            if (level.mayInteract((Entity)player, pos) && player.mayUseItemAt(pos, blockhitresult.getDirection(), itemstack)) {
                Entity entity = ForkliftSpawnEggItem.getType().spawn(serverLevel, itemstack, (LivingEntity)player, pos, EntitySpawnReason.SPAWN_ITEM_USE, false, false);
                if (entity == null) {
                    return InteractionResult.PASS;
                }
                itemstack.consume(1, (LivingEntity)player);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, entity.position());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!level.isClientSide) {
            ItemStack itemstack = context.getItemInHand();
            BlockPos blockpos = context.getClickedPos();
            Direction direction = context.getClickedFace();
            BlockState blockstate = level.getBlockState(blockpos);
            BlockEntity blockEntity = level.getBlockEntity(blockpos);
            if (blockEntity instanceof Spawner) {
                Spawner spawner = (Spawner)blockEntity;
                spawner.setEntityId(ForkliftSpawnEggItem.getType(), level.getRandom());
                level.sendBlockUpdated(blockpos, blockstate, blockstate, 3);
                level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.BLOCK_CHANGE, blockpos);
                itemstack.shrink(1);
            } else {
                BlockPos placePos = blockstate.getCollisionShape((BlockGetter)level, blockpos).isEmpty() ? blockpos : blockpos.relative(direction);
                if (ForkliftSpawnEggItem.getType().spawn((ServerLevel)level, itemstack, (LivingEntity)context.getPlayer(), placePos, EntitySpawnReason.SPAWN_ITEM_USE, true, !Objects.equals(blockpos, placePos) && direction == Direction.UP) != null) {
                    itemstack.shrink(1);
                    level.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockpos);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }
}

