/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.item;

import com.google.common.base.Suppliers;
import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.client.entity.model.HighHeelsModel;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;

@EventBusSubscriber(modid="ltextras")
public class HighHeelsItem
extends Item {
    public HighHeelsItem(Item.Properties properties) {
        super(properties);
    }

    @SubscribeEvent
    public static void onEquip(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (event.getTo().has(ExtraDataComponents.ADJUST_HEIGHT) || event.getFrom().has(ExtraDataComponents.ADJUST_HEIGHT)) {
            Pose pose = livingEntity.getPose();
            livingEntity.setPose(Pose.CROUCHING);
            livingEntity.setPose(pose);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSize(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        if (entity.isAddedToLevel() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            float adjustedHeight = 0.0f;
            for (EquipmentSlot equipmentslot : EquipmentSlotGroup.ARMOR) {
                ItemStack armorItem = livingEntity.getItemBySlot(equipmentslot);
                if (armorItem.isEmpty()) continue;
                adjustedHeight += ((Float)armorItem.getOrDefault(ExtraDataComponents.ADJUST_HEIGHT, (Object)Float.valueOf(0.0f))).floatValue();
            }
            if (adjustedHeight != 0.0f) {
                EntityDimensions dimensions = event.getNewSize();
                EntityDimensions newDimensions = new EntityDimensions(dimensions.width(), Mth.clamp((float)(dimensions.height() + adjustedHeight), (float)0.0f, (float)Float.MAX_VALUE), Mth.clamp((float)(dimensions.eyeHeight() + adjustedHeight), (float)0.0f, (float)Float.MAX_VALUE), dimensions.attachments(), dimensions.fixed());
                event.setNewSize(newDimensions);
            }
        }
    }

    public static class ClientExtensions
    implements IClientItemExtensions {
        private static final ResourceLocation TEXTURE = LTExtras.location("textures/entity/high_heels.png");
        private final Supplier<HighHeelsModel> model = Suppliers.memoize(() -> new HighHeelsModel(Minecraft.getInstance().getEntityModels().bakeLayer(HighHeelsModel.LAYER_LOCATION)));

        public Model getHumanoidArmorModel(ItemStack itemStack, EquipmentClientInfo.LayerType layerType, Model original) {
            return (Model)this.model.get();
        }

        public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
            return TEXTURE;
        }
    }
}

