/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;

public record InteractActionData(List<ClickEvent> clickEvents, boolean cancelEvent) {
    public static final Codec<InteractActionData> CODEC = RecordCodecBuilder.create(i -> i.group((App)ExtraCodecs.compactListCodec((Codec)ClickEvent.CODEC).fieldOf("click_events").forGetter(InteractActionData::clickEvents), (App)Codec.BOOL.optionalFieldOf("cancel_event", (Object)false).forGetter(InteractActionData::cancelEvent)).apply((Applicative)i, InteractActionData::new));

    public void performCommands(ServerPlayer player) {
        for (ClickEvent clickEvent : this.clickEvents) {
            ClickEvent clickEvent2;
            Objects.requireNonNull(clickEvent);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClickEvent.RunCommand.class, ClickEvent.ShowDialog.class, ClickEvent.Custom.class}, (Object)clickEvent2, n)) {
                case 0: {
                    ClickEvent.RunCommand runCommand = (ClickEvent.RunCommand)clickEvent2;
                    CommandSourceStack targetSource = player.createCommandSourceStack().withPermission(2);
                    player.level().getServer().getCommands().performPrefixedCommand(targetSource, runCommand.command());
                    break;
                }
                case 1: {
                    ClickEvent.ShowDialog showDialog = (ClickEvent.ShowDialog)clickEvent2;
                    player.openDialog(showDialog.dialog());
                    break;
                }
                case 2: {
                    ClickEvent.Custom custom = (ClickEvent.Custom)clickEvent2;
                    player.level().getServer().handleCustomClickAction(custom.id(), custom.payload());
                    break;
                }
            }
        }
    }
}

