/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import org.jetbrains.annotations.Nullable;

public record WalkSound(Holder<SoundEvent> soundEvent, FloatProvider cooldown, FloatProvider volume, FloatProvider pitch, boolean playOtherSounds) {
    private static final FloatProvider DEFAULT_COOLDOWN = ConstantFloat.of((float)1.0f);
    private static final FloatProvider DEFAULT_VOLUME = ConstantFloat.of((float)0.15f);
    private static final FloatProvider DEFAULT_PITCH = ConstantFloat.of((float)1.0f);
    private static final boolean DEFAULT_PLAY_OTHER_SOUNDS = false;
    public static final Codec<WalkSound> CODEC = RecordCodecBuilder.create(i -> i.group((App)SoundEvent.CODEC.fieldOf("sound").forGetter(WalkSound::soundEvent), (App)FloatProvider.CODEC.optionalFieldOf("cooldown", (Object)DEFAULT_COOLDOWN).forGetter(WalkSound::cooldown), (App)FloatProvider.CODEC.optionalFieldOf("volume", (Object)DEFAULT_VOLUME).forGetter(WalkSound::volume), (App)FloatProvider.CODEC.optionalFieldOf("pitch", (Object)DEFAULT_PITCH).forGetter(WalkSound::pitch), (App)Codec.BOOL.optionalFieldOf("play_other_sounds", (Object)false).forGetter(WalkSound::playOtherSounds)).apply((Applicative)i, WalkSound::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WalkSound> STREAM_CODEC = StreamCodec.composite((StreamCodec)SoundEvent.STREAM_CODEC, WalkSound::soundEvent, (StreamCodec)ByteBufCodecs.fromCodec((Codec)FloatProvider.CODEC), WalkSound::cooldown, (StreamCodec)ByteBufCodecs.fromCodec((Codec)FloatProvider.CODEC), WalkSound::volume, (StreamCodec)ByteBufCodecs.fromCodec((Codec)FloatProvider.CODEC), WalkSound::pitch, (StreamCodec)ByteBufCodecs.fromCodec((Codec)Codec.BOOL), WalkSound::playOtherSounds, WalkSound::new);

    public WalkSound(Holder<SoundEvent> soundEvent) {
        this(soundEvent, DEFAULT_COOLDOWN, DEFAULT_VOLUME, DEFAULT_PITCH, false);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private Holder<SoundEvent> soundEvent = null;
        private FloatProvider cooldown = DEFAULT_COOLDOWN;
        private FloatProvider volume = DEFAULT_VOLUME;
        private FloatProvider pitch = DEFAULT_PITCH;
        private boolean playOtherSounds = false;

        public Builder soundEvent(Holder<SoundEvent> soundEvent) {
            this.soundEvent = soundEvent;
            return this;
        }

        public Builder cooldown(FloatProvider cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder cooldown(float cooldown) {
            return this.cooldown((FloatProvider)ConstantFloat.of((float)cooldown));
        }

        public Builder volume(FloatProvider volume) {
            this.volume = volume;
            return this;
        }

        public Builder volume(float volume) {
            return this.volume((FloatProvider)ConstantFloat.of((float)volume));
        }

        public Builder pitch(FloatProvider pitch) {
            this.pitch = pitch;
            return this;
        }

        public Builder pitch(float pitch) {
            return this.pitch((FloatProvider)ConstantFloat.of((float)pitch));
        }

        public Builder playOtherSounds(boolean playOtherSounds) {
            this.playOtherSounds = playOtherSounds;
            return this;
        }

        public WalkSound build() {
            if (this.soundEvent == null) {
                throw new IllegalStateException("Sound event must be set");
            }
            return new WalkSound(this.soundEvent, this.cooldown, this.volume, this.pitch, this.playOtherSounds);
        }
    }
}

