/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.item.sensor;

import com.lovetropics.lib.codec.MoreCodecs;
import com.lovetropics.lib.permission.PermissionsApi;
import com.lovetropics.lib.permission.role.Role;
import com.lovetropics.lib.permission.role.RoleReader;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record PlayerSensor(List<String> tags, List<String> roles, Appearance appearance) {
    public static final Codec<PlayerSensor> CODEC = RecordCodecBuilder.create(i -> i.group((App)MoreCodecs.listOrUnit((Codec)Codec.STRING).optionalFieldOf("tag", List.of()).forGetter(PlayerSensor::tags), (App)MoreCodecs.listOrUnit((Codec)Codec.STRING).optionalFieldOf("roles", List.of()).forGetter(PlayerSensor::roles), (App)Appearance.CODEC.fieldOf("appearance").forGetter(PlayerSensor::appearance)).apply((Applicative)i, PlayerSensor::new));
    public static final StreamCodec<ByteBuf, PlayerSensor> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), PlayerSensor::tags, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), PlayerSensor::roles, Appearance.STREAM_CODEC, PlayerSensor::appearance, PlayerSensor::new);

    public boolean matches(ServerPlayer player) {
        for (String tag : this.tags) {
            if (!player.getTags().contains(tag)) continue;
            return true;
        }
        if (!this.roles.isEmpty()) {
            RoleReader reader = PermissionsApi.lookup().byPlayer((Player)player);
            for (String roleId : this.roles) {
                Role role = PermissionsApi.provider().get(roleId);
                if (!reader.has(role)) continue;
                return true;
            }
        }
        return false;
    }

    public record Appearance(int color, Optional<Sprite> faceDecoration) {
        public static final Codec<Appearance> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("color").forGetter(Appearance::color), (App)Sprite.CODEC.optionalFieldOf("face_decoration").forGetter(Appearance::faceDecoration)).apply((Applicative)i, Appearance::new));
        public static final StreamCodec<ByteBuf, Appearance> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Appearance::color, (StreamCodec)Sprite.STREAM_CODEC.apply(ByteBufCodecs::optional), Appearance::faceDecoration, Appearance::new);
    }

    public record Sprite(ResourceLocation location, int width, int height) {
        public static final Codec<Sprite> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("location").forGetter(Sprite::location), (App)Codec.INT.fieldOf("width").forGetter(Sprite::width), (App)Codec.INT.fieldOf("height").forGetter(Sprite::height)).apply((Applicative)i, Sprite::new));
        public static final StreamCodec<ByteBuf, Sprite> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, Sprite::location, (StreamCodec)ByteBufCodecs.VAR_INT, Sprite::width, (StreamCodec)ByteBufCodecs.VAR_INT, Sprite::height, Sprite::new);
    }
}

