/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.item.sensor;

import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.item.sensor.PlayerSensor;
import com.lovetropics.extras.network.message.ClientboundSetEntityMarkedPacket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="ltextras")
public class ServerPlayerSensorManager {
    private static final int REFRESH_INTERVAL_TICKS = 5;
    private static final Map<UUID, SensorState> SENSOR_STATES = new HashMap<UUID, SensorState>();

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        SENSOR_STATES.remove(event.getEntity().getUUID());
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.tickCount % 5 != 0) {
                return;
            }
            ItemStack headItem = player2.getItemBySlot(EquipmentSlot.HEAD);
            PlayerSensor sensor = (PlayerSensor)headItem.get(ExtraDataComponents.PLAYER_SENSOR);
            SensorState sensorState = SENSOR_STATES.get(player2.getUUID());
            if (sensorState != null) {
                sensorState.refresh(player2, sensor);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTracked(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof ServerPlayer) {
                ServerPlayer target = (ServerPlayer)player;
                SensorState state = SENSOR_STATES.computeIfAbsent(player2.getUUID(), playerId -> new SensorState());
                state.startTracking(player2, target);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerUntracked(PlayerEvent.StopTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof ServerPlayer) {
                ServerPlayer target = (ServerPlayer)player;
                SensorState state = SENSOR_STATES.get(player2.getUUID());
                if (state != null) {
                    state.stopTracking(target);
                }
            }
        }
    }

    private static class SensorState {
        @Nullable
        private PlayerSensor activeSensor;
        private final Set<UUID> trackedPlayers = new HashSet<UUID>();
        private final Set<UUID> markedPlayers = new HashSet<UUID>();

        private SensorState() {
        }

        public void refresh(ServerPlayer player, @Nullable PlayerSensor sensor) {
            this.activeSensor = sensor;
            ServerLevel level = player.level();
            this.markedPlayers.removeIf(playerId -> {
                Player patt0$temp = level.getPlayerByUUID(playerId);
                if (!(patt0$temp instanceof ServerPlayer)) {
                    return true;
                }
                ServerPlayer target = (ServerPlayer)patt0$temp;
                if (this.activeSensor == null || !this.activeSensor.matches(target)) {
                    player.connection.send((CustomPacketPayload)new ClientboundSetEntityMarkedPacket(target.getId(), Optional.empty()));
                    return true;
                }
                return false;
            });
            for (UUID playerId2 : this.trackedPlayers) {
                Player player2;
                if (this.markedPlayers.contains(playerId2) || !((player2 = level.getPlayerByUUID(playerId2)) instanceof ServerPlayer)) continue;
                ServerPlayer target = (ServerPlayer)player2;
                if (this.activeSensor == null || !this.activeSensor.matches(target)) continue;
                this.markedPlayers.add(playerId2);
                player.connection.send((CustomPacketPayload)new ClientboundSetEntityMarkedPacket(target.getId(), Optional.of(this.activeSensor.appearance())));
            }
        }

        public void startTracking(ServerPlayer player, ServerPlayer target) {
            this.trackedPlayers.add(target.getUUID());
            this.refresh(player, this.activeSensor);
        }

        public void stopTracking(ServerPlayer target) {
            this.trackedPlayers.remove(target.getUUID());
            this.markedPlayers.remove(target.getUUID());
        }
    }
}

