/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.mixin;

import com.lovetropics.extras.entity.ForkliftEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.class})
public class BlockBehaviourMixin {
    @Unique
    private static final VoxelShape HACK_SHAPE = Block.cube((double)16.5);

    @Inject(method={"getCollisionShape"}, at={@At(value="HEAD")}, cancellable=true)
    public void onGetCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        ForkliftEntity forkliftEntity;
        EntityCollisionContext ctx;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (ctx = (EntityCollisionContext)context).getEntity()) instanceof ForkliftEntity && (forkliftEntity = (ForkliftEntity)entity).shouldDestroyBlock(pos, state)) {
            forkliftEntity.destroyBlock(state, entity.level(), pos);
            cir.setReturnValue((Object)Shapes.empty());
        }
    }
}

