/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.mixin;

import com.lovetropics.extras.block.entity.MobControllerBlockEntity;
import com.lovetropics.extras.entity.ExtendedCreatureEntity;
import com.lovetropics.extras.entity.ai.MoveBackToOriginGoal;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={PathfinderMob.class})
public abstract class CreatureEntityMixin
extends Mob
implements ExtendedCreatureEntity {
    private boolean theresNoPlaceLikeHome;
    @Nullable
    private Vec3 homePos;
    private int homeRange;

    protected CreatureEntityMixin(EntityType<? extends Mob> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.theresNoPlaceLikeHome = input.getBooleanOr("TheresNoPlaceLikeHome", false);
        if (this.theresNoPlaceLikeHome) {
            this.homePos = input.read("HomePos", Vec3.CODEC).orElse(this.position());
            this.homeRange = input.getIntOr("HomeRange", 20);
            this.goalSelector.addGoal(0, (Goal)new MoveBackToOriginGoal((PathfinderMob)this, 1.0, this.homePos, this.homeRange));
        }
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        if (this.theresNoPlaceLikeHome) {
            output.putBoolean("TheresNoPlaceLikeHome", true);
            output.putInt("HomeRange", this.homeRange);
            output.storeNullable("HomePos", Vec3.CODEC, (Object)this.homePos);
        }
    }

    @Override
    public void linkToBlockEntity(MobControllerBlockEntity controller) {
        BlockPos pos = controller.getBlockPos();
        this.theresNoPlaceLikeHome = true;
        this.homePos = new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        this.homeRange = 32;
    }
}

