/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.lovetropics.extras.ExtraDataComponents;
import com.lovetropics.extras.effect.ExtraEffects;
import com.lovetropics.extras.item.WalkSound;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.TeleportTransition;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Shadow
    @Final
    private Set<String> tags;
    @Shadow
    private FluidType forgeFluidTypeOnEyes;
    @Unique
    private static final String lTExtras$UNTOUCHABLE = "Untouchable";

    @Unique
    @Inject(method={"kill"}, at={@At(value="HEAD")}, cancellable=true)
    public void kill(CallbackInfo ci) {
        if (this.tags.contains(lTExtras$UNTOUCHABLE)) {
            ci.cancel();
        }
    }

    @Inject(method={"teleportTo(DDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void teleportToXYZ(CallbackInfo ci) {
        if (this.tags.contains(lTExtras$UNTOUCHABLE)) {
            ci.cancel();
        }
    }

    @Inject(method={"teleport"}, at={@At(value="HEAD")}, cancellable=true)
    public void teleportTo(TeleportTransition teleportTransition, CallbackInfoReturnable<Entity> cir) {
        if (this.tags.contains(lTExtras$UNTOUCHABLE)) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"snapTo(DDDFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void snapTo(double x, double y, double z, float yRot, float xRot, CallbackInfo ci) {
        if (this.tags.contains(lTExtras$UNTOUCHABLE)) {
            ci.cancel();
        }
    }

    @Inject(method={"setRemoved"}, at={@At(value="HEAD")}, cancellable=true)
    public final void setRemoved(Entity.RemovalReason removalReason, CallbackInfo ci) {
        if (removalReason == Entity.RemovalReason.KILLED && this.tags.contains(lTExtras$UNTOUCHABLE)) {
            ci.cancel();
        }
    }

    @Inject(method={"updateFluidOnEyes"}, at={@At(value="RETURN")})
    private void updateFluidOnEyes(CallbackInfo ci) {
        LivingEntity livingEntity;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof LivingEntity && (livingEntity = (LivingEntity)entityMixin).hasEffect(ExtraEffects.FISH_EYE)) {
            this.forgeFluidTypeOnEyes = (FluidType)NeoForgeMod.EMPTY_TYPE.value();
        }
    }

    @Inject(method={"nextStep"}, at={@At(value="RETURN")}, cancellable=true)
    private void nextStep(CallbackInfoReturnable<Float> cir) {
        LivingEntity livingEntity;
        WalkSound sound;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof LivingEntity && (sound = (WalkSound)(livingEntity = (LivingEntity)entityMixin).getItemBySlot(EquipmentSlot.FEET).get(ExtraDataComponents.WALK_SOUND)) != null) {
            cir.setReturnValue((Object)Float.valueOf(livingEntity.moveDist + sound.cooldown().sample(livingEntity.getRandom())));
        }
    }

    @Inject(method={"walkingStepSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void walkingStepSound(BlockPos pos, BlockState state, CallbackInfo ci) {
        LivingEntity livingEntity;
        WalkSound sound;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof LivingEntity && (sound = (WalkSound)(livingEntity = (LivingEntity)entityMixin).getItemBySlot(EquipmentSlot.FEET).get(ExtraDataComponents.WALK_SOUND)) != null) {
            livingEntity.playSound((SoundEvent)sound.soundEvent().value(), sound.volume().sample(livingEntity.getRandom()), sound.pitch().sample(livingEntity.getRandom()));
            if (!sound.playOtherSounds()) {
                ci.cancel();
            }
        }
    }

    @ModifyExpressionValue(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/EntityType;canSerialize()Z")})
    private boolean skipChecks(boolean original) {
        return true;
    }

    @Inject(method={"isPushable"}, at={@At(value="HEAD")}, cancellable=true)
    private void isPushable(CallbackInfoReturnable<Boolean> cir) {
        if (this.tags.contains("NoPush")) {
            cir.setReturnValue((Object)false);
        }
    }
}

