/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.mixin.client.menu;

import com.lovetropics.extras.LTExtras;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;

@Mixin(value={LogoRenderer.class})
public class LogoRendererMixin {
    @Shadow
    @Final
    private boolean keepLogoThroughFade;
    @Unique
    private static final ResourceLocation LOVE_TROPICS_TEXTURE = LTExtras.location("textures/gui/title.png");

    @ModifyConstant(method={"renderLogo(Lnet/minecraft/client/gui/GuiGraphics;IF)V"}, constant={@Constant(intValue=30)})
    private int modifyDefaultHeight(int height) {
        return height - 10;
    }

    @Overwrite
    public void renderLogo(GuiGraphics graphics, int screenWidth, float transparency, int height) {
        int x = (screenWidth - 256) / 2;
        int color = ARGB.white((float)(this.keepLogoThroughFade ? 1.0f : transparency));
        graphics.blit(RenderPipelines.GUI_TEXTURED, LOVE_TROPICS_TEXTURE, x, height, 0.0f, 0.0f, 256, 38, 256, 64, color);
    }
}

