/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.mixin.placeholder;

import com.lovetropics.extras.network.message.ClientboundSetDisplayTextPacket;
import com.mojang.serialization.Codec;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Display.TextDisplay.class})
public abstract class TextDisplayMixin
extends Display {
    @Unique
    private static final int ltextras$UPDATE_INTERVAL = 20;
    @Unique
    private static final Codec<String> ltextras$TEMPLATE_CODEC = Codec.withAlternative((Codec)Codec.STRING, (Codec)Codec.STRING.listOf(), strings -> String.join((CharSequence)"<r>\n", strings));
    @Unique
    private static final NodeParser ltextras$TEXT_PARSER = NodeParser.builder().simplifiedTextFormat().quickText().globalPlaceholders().staticPreParsing().build();
    @Unique
    @Nullable
    private String ltextras$templateText;
    @Unique
    @Nullable
    private TextNode ltextras$parsedTemplate;
    @Unique
    private final Map<ServerPlayer, Component> ltextras$trackingPlayers = new Reference2ObjectOpenHashMap();

    public TextDisplayMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    protected abstract Component getText();

    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && !this.ltextras$trackingPlayers.isEmpty() && this.tickCount % 20 == 0) {
            this.ltextras$sendTextUpdatesToPlayers();
        }
    }

    @Unique
    private void ltextras$sendTextUpdatesToPlayers() {
        for (Map.Entry<ServerPlayer, Component> entry : this.ltextras$trackingPlayers.entrySet()) {
            ServerPlayer player = entry.getKey();
            Component text = this.ltextras$resolveTextForPlayer(player);
            if (text.equals((Object)entry.getValue())) continue;
            entry.setValue(text);
            this.ltextras$sendTextToPlayer(player, text);
        }
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        Component text = this.ltextras$resolveTextForPlayer(player);
        this.ltextras$trackingPlayers.put(player, text);
        if (!text.equals((Object)this.getText())) {
            this.ltextras$sendTextToPlayer(player, text);
        }
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.ltextras$trackingPlayers.remove(player);
    }

    @Unique
    private Component ltextras$resolveTextForPlayer(ServerPlayer player) {
        if (this.ltextras$parsedTemplate != null) {
            PlaceholderContext context = PlaceholderContext.of((ServerPlayer)player);
            return this.ltextras$parsedTemplate.toText(context);
        }
        return this.getText();
    }

    @Unique
    private void ltextras$sendTextToPlayer(ServerPlayer player, Component text) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundSetDisplayTextPacket(this.getId(), text), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Unique
    private void ltextras$setTemplateText(@Nullable String templateText) {
        this.ltextras$templateText = templateText;
        this.ltextras$parsedTemplate = templateText != null ? ltextras$TEXT_PARSER.parseNode(templateText) : null;
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void readAdditionalSaveData(ValueInput input, CallbackInfo ci) {
        this.ltextras$setTemplateText(input.read("template", ltextras$TEMPLATE_CODEC).orElse(null));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void addAdditionalSaveData(ValueOutput output, CallbackInfo ci) {
        output.storeNullable("template", ltextras$TEMPLATE_CODEC, (Object)this.ltextras$templateText);
    }
}

