/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.model_modifer;

import com.google.common.collect.Sets;
import com.lovetropics.extras.command.arguments.ModelModifierArgumentType;
import com.lovetropics.extras.data.attachment.ExtraAttachments;
import com.lovetropics.extras.model_modifer.ModelModifierStore;
import com.lovetropics.extras.model_modifer.ModelModifierType;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;

public class ModelModifierCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"modelmodifer").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"add").then(Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"modifier", (ArgumentType)ModelModifierArgumentType.modelModifier()).executes(ctx -> ModelModifierCommand.addModifier((CommandContext<CommandSourceStack>)ctx, (ModelModifierType)((Object)((Object)ctx.getArgument("modifier", ModelModifierType.class))), EntityArgument.getEntities((CommandContext)ctx, (String)"entities"))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"modifier", (ArgumentType)ModelModifierArgumentType.modelModifier()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(ModelModifierCommand.getModifiers(EntityArgument.getEntities((CommandContext)ctx, (String)"entities")), (SuggestionsBuilder)builder)).executes(ctx -> ModelModifierCommand.removeModifier((CommandContext<CommandSourceStack>)ctx, (ModelModifierType)((Object)((Object)ctx.getArgument("modifier", ModelModifierType.class))), EntityArgument.getEntities((CommandContext)ctx, (String)"entities"))))))).then(Commands.literal((String)"reset").then(Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).executes(ctx -> ModelModifierCommand.resetModifiers((CommandContext<CommandSourceStack>)ctx, EntityArgument.getEntities((CommandContext)ctx, (String)"entities")))))).then(Commands.literal((String)"list").then(Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).executes(ctx -> ModelModifierCommand.listModifiers((CommandContext<CommandSourceStack>)ctx, EntityArgument.getEntities((CommandContext)ctx, (String)"entities"))))));
    }

    private static int addModifier(CommandContext<CommandSourceStack> ctx, ModelModifierType modifier, Collection<? extends Entity> entities) {
        for (Entity entity : entities) {
            ModelModifierStore.addModifier(entity, modifier);
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Added " + modifier.getSerializedName() + " model modifier to " + entities.size() + " entities")), true);
        return 1;
    }

    private static int removeModifier(CommandContext<CommandSourceStack> ctx, ModelModifierType modifier, Collection<? extends Entity> entities) {
        for (Entity entity : entities) {
            ModelModifierStore.removeModifier(entity, modifier);
            entity.syncData(ExtraAttachments.MODEL_MODIFIERS);
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Removed " + modifier.getSerializedName() + " model modifier for " + entities.size() + " entities")), true);
        return 1;
    }

    private static int resetModifiers(CommandContext<CommandSourceStack> ctx, Collection<? extends Entity> entities) {
        for (Entity entity : entities) {
            ModelModifierStore.resetModifiers(entity);
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Cleared model modifiers from " + entities.size() + " entities")), true);
        return 1;
    }

    private static int listModifiers(CommandContext<CommandSourceStack> ctx, Collection<? extends Entity> entities) {
        ArrayList<ModelModifierType> modifiers = new ArrayList<ModelModifierType>();
        for (Entity entity : entities) {
            List<ModelModifierType> modelModifierTypes = ModelModifierStore.getOrDefault(entity).appliedModifiers();
            for (ModelModifierType modelModifierType : modelModifierTypes) {
                if (modifiers.contains((Object)modelModifierType)) continue;
                modifiers.add(modelModifierType);
            }
        }
        String modifierString = modifiers.stream().map(ModelModifierType::getSerializedName).collect(Collectors.joining(", "));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(entities.size() + " have " + modifierString + " modifers")), true);
        return 1;
    }

    private static Collection<String> getModifiers(Collection<? extends Entity> entities) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : entities) {
            set.addAll(ModelModifierStore.getOrDefault(entity).getFormattedModifierNames());
        }
        return set;
    }
}

