/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.model_modifer;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.Nullable;

public enum ModelModifierType implements StringRepresentable
{
    DEFAULT(0, "default"),
    FABULOUS(1, "fabulous", "Fabulous Walk"),
    FLAIL(2, "flail", "Flail Walk"),
    HOVERING(3, "hovering", "Hovering"),
    SHUFFLE(4, "shuffle", "The Shuffle"),
    UPSIDEDOWN(5, "upsidedown", "Upside Down"),
    SHRUNK(6, "shrunk", "Shrunk"),
    ENLARGED(7, "enlarged", "Enlarged"),
    RAISED_HIGH_HEELS(8, "raised_high_heels"),
    SHRUGGY_ARMS(9, "shruggy_arms", "Shruggy Arms"),
    ENDER_ARMS(10, "ender_arms", "Ender Arms"),
    STIFF_LEGS(11, "stiff_legs", "Stiff Legs"),
    HOP_WALK(12, "hop_walk", "Hop Walk");

    public static final StringRepresentable.EnumCodec<ModelModifierType> CODEC;
    public static final IntFunction<ModelModifierType> BY_ID;
    public static final StreamCodec<ByteBuf, ModelModifierType> STREAM_CODEC;
    public static final List<String> NAMES;
    private final int id;
    private final String name;
    @Nullable
    private final String effectName;

    private ModelModifierType(@Nullable int id, String name, String effectName) {
        this.id = id;
        this.name = name;
        this.effectName = effectName;
    }

    private ModelModifierType(int id, String name) {
        this(id, name, null);
    }

    @Nullable
    public String getEffectName() {
        return this.effectName;
    }

    public static ModelModifierType fromName(String name) {
        return (ModelModifierType)CODEC.byName(name, (Enum)DEFAULT);
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(ModelModifierType::values);
        BY_ID = ByIdMap.continuous(i -> i.id, (Object[])ModelModifierType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, i -> i.id);
        NAMES = Arrays.stream(ModelModifierType.values()).map(ModelModifierType::getSerializedName).toList();
    }
}

