/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.mounts;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.SummonCommand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;

public class MountCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"mount").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.ENTITY_TYPE)).executes(ctx -> MountCommand.summonMount((CommandSourceStack)ctx.getSource(), ResourceArgument.getSummonableEntityType((CommandContext)ctx, (String)"entity"), new CompoundTag()))).then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(ctx -> MountCommand.summonMount((CommandSourceStack)ctx.getSource(), ResourceArgument.getSummonableEntityType((CommandContext)ctx, (String)"entity"), CompoundTagArgument.getCompoundTag((CommandContext)ctx, (String)"nbt")))))));
    }

    private static int summonMount(CommandSourceStack source, Holder.Reference<EntityType<?>> entity, CompoundTag nbt) throws CommandSyntaxException {
        Entity commandEntity = source.getEntityOrException();
        Entity spawnEntity = SummonCommand.createEntity((CommandSourceStack)source, entity, (Vec3)source.getPosition(), (CompoundTag)nbt, (boolean)false);
        commandEntity.startRiding(spawnEntity, true);
        spawnEntity.addTag("remove_on_dismount");
        return 1;
    }
}

