/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.network.message;

import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.entity.ForkliftEntity;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundDriftForkliftPacket(boolean drift, int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundDriftForkliftPacket> TYPE = new CustomPacketPayload.Type(LTExtras.location("drift_forklift"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundDriftForkliftPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ServerboundDriftForkliftPacket::drift, (StreamCodec)ByteBufCodecs.VAR_INT, ServerboundDriftForkliftPacket::entityId, ServerboundDriftForkliftPacket::new);

    public static void handle(ServerboundDriftForkliftPacket packet, IPayloadContext ctx) {
        Level level = ctx.player().level();
        Entity entity = level.getEntity(packet.entityId);
        if (entity instanceof ForkliftEntity) {
            ForkliftEntity forklift = (ForkliftEntity)entity;
            forklift.setDrifting(packet.drift);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

