/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.network.message;

import com.lovetropics.extras.ExtraItems;
import com.lovetropics.extras.data.TropiCoinsStore;
import com.lovetropics.extras.data.attachment.ExtraAttachments;
import com.lovetropics.extras.mixin.AbstractContainerMenuAccess;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundExchangeTropiCoinsPacket(boolean store, int count) implements CustomPacketPayload
{
    public static final StreamCodec<ByteBuf, ServerboundExchangeTropiCoinsPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ServerboundExchangeTropiCoinsPacket::store, (StreamCodec)ByteBufCodecs.VAR_INT, ServerboundExchangeTropiCoinsPacket::count, ServerboundExchangeTropiCoinsPacket::new);
    public static final CustomPacketPayload.Type<ServerboundExchangeTropiCoinsPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"ltextras", (String)"exchange_tropicoins"));

    public static void handle(ServerboundExchangeTropiCoinsPacket packet, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            boolean success = packet.store ? ServerboundExchangeTropiCoinsPacket.handleStore(player2, packet.count) : ServerboundExchangeTropiCoinsPacket.handleRetrieve(player2, packet.count);
            if (success) {
                ServerboundExchangeTropiCoinsPacket.setRemoteCarried(player2.containerMenu, player2.containerMenu.getCarried());
            } else {
                player2.syncData(ExtraAttachments.TROPICOINS_STORE);
                player2.containerMenu.sendAllDataToRemote();
            }
        }
    }

    private static boolean handleStore(ServerPlayer player, int requestedCount) {
        ItemStack carried = player.containerMenu.getCarried();
        if (!carried.is(ExtraItems.TROPICOIN)) {
            return false;
        }
        int actualCount = Math.min(requestedCount, carried.getCount());
        TropiCoinsStore store = (TropiCoinsStore)player.getData(ExtraAttachments.TROPICOINS_STORE);
        carried.shrink(actualCount);
        store.setAmount(store.getAmount() + actualCount);
        return actualCount == requestedCount;
    }

    private static boolean handleRetrieve(ServerPlayer player, int requestedCount) {
        ItemStack carried = player.containerMenu.getCarried();
        if (carried.isEmpty()) {
            TropiCoinsStore store = (TropiCoinsStore)player.getData(ExtraAttachments.TROPICOINS_STORE);
            int actualCount = requestedCount;
            actualCount = Math.min(actualCount, store.getAmount());
            actualCount = Math.min(actualCount, ((Item)ExtraItems.TROPICOIN.get()).getDefaultMaxStackSize());
            store.setAmount(store.getAmount() - actualCount);
            player.containerMenu.setCarried(new ItemStack((ItemLike)ExtraItems.TROPICOIN.get(), actualCount));
            return actualCount == requestedCount;
        }
        if (carried.is(ExtraItems.TROPICOIN)) {
            TropiCoinsStore store = (TropiCoinsStore)player.getData(ExtraAttachments.TROPICOINS_STORE);
            int actualCount = requestedCount;
            actualCount = Math.min(actualCount, store.getAmount());
            actualCount = Math.min(actualCount, carried.getMaxStackSize() - carried.getCount());
            store.setAmount(store.getAmount() - actualCount);
            carried.grow(actualCount);
            return actualCount == requestedCount;
        }
        return false;
    }

    private static void setRemoteCarried(AbstractContainerMenu menu, ItemStack carried) {
        ((AbstractContainerMenuAccess)menu).getRemoteCarried().force(carried);
    }

    public CustomPacketPayload.Type<ServerboundExchangeTropiCoinsPacket> type() {
        return TYPE;
    }
}

