/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.network.message;

import com.lovetropics.extras.LTExtras;
import com.lovetropics.extras.entity.ForkliftEntity;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundLiftForkliftPacket(boolean eject, int forkHeight, int entityId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundLiftForkliftPacket> TYPE = new CustomPacketPayload.Type(LTExtras.location("lift_forklift"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundLiftForkliftPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ServerboundLiftForkliftPacket::eject, (StreamCodec)ByteBufCodecs.VAR_INT, ServerboundLiftForkliftPacket::forkHeight, (StreamCodec)ByteBufCodecs.VAR_INT, ServerboundLiftForkliftPacket::entityId, ServerboundLiftForkliftPacket::new);

    public static void handle(ServerboundLiftForkliftPacket packet, IPayloadContext ctx) {
        int forkHeight = packet.forkHeight;
        Level level = ctx.player().level();
        Entity entity = level.getEntity(packet.entityId);
        if (entity instanceof ForkliftEntity) {
            ForkliftEntity forklift = (ForkliftEntity)entity;
            int heightBefore = forklift.getForkHeight();
            int heightChanged = Mth.abs((int)(forkHeight - heightBefore));
            forklift.setForkHeight(forkHeight);
            if (packet.eject) {
                for (Entity passenger : forklift.getPassengers()) {
                    if (forklift.getControllingPassenger() != null && passenger.is((Entity)forklift.getControllingPassenger())) continue;
                    passenger.stopRiding();
                    passenger.hasImpulse = true;
                    float force = (float)heightChanged / 18.0f;
                    double ejectY = level.random.triangle(force, 0.1f + force);
                    Vec3 forkMotion = forklift.getKnownMovement();
                    double newVelX = forkMotion.x;
                    double newVelY = (forklift.onGround() ? 0.0 : forkMotion.y) + ejectY;
                    double newVelZ = forkMotion.z;
                    passenger.setDeltaMovement(newVelX, newVelY, newVelZ);
                }
                level.playSound((Entity)forklift, forklift.blockPosition(), SoundEvents.BREEZE_JUMP, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

