/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.placeholder;

import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerScoreEntry;

public class ExtraPlaceholders {
    public static void init() {
        Placeholders.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"server", (String)"objective_name_bottom"), (ctx, arg) -> {
            String[] args = arg.split(" ");
            if (args.length >= 2) {
                ServerScoreboard scoreboard = ctx.server().getScoreboard();
                Objective scoreboardObjective = scoreboard.getObjective(args[0]);
                if (scoreboardObjective == null) {
                    return PlaceholderResult.invalid((String)"Invalid objective!");
                }
                try {
                    int position = Integer.parseInt(args[1]);
                    ArrayList<PlayerScoreEntry> scoreboardEntries = new ArrayList<PlayerScoreEntry>(scoreboard.listPlayerScores(scoreboardObjective));
                    scoreboardEntries.sort(Comparator.comparingInt(PlayerScoreEntry::value));
                    PlayerScoreEntry scoreboardEntry = (PlayerScoreEntry)scoreboardEntries.get(position - 1);
                    return PlaceholderResult.value((Component)scoreboardEntry.ownerName());
                }
                catch (Exception e) {
                    return PlaceholderResult.invalid((String)"Invalid position!");
                }
            }
            return PlaceholderResult.invalid((String)"Not enough arguments!");
        });
        Placeholders.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"server", (String)"objective_score_bottom"), (ctx, arg) -> {
            String[] args = arg.split(" ");
            if (args.length >= 2) {
                ServerScoreboard scoreboard = ctx.server().getScoreboard();
                Objective scoreboardObjective = scoreboard.getObjective(args[0]);
                if (scoreboardObjective == null) {
                    return PlaceholderResult.invalid((String)"Invalid objective!");
                }
                try {
                    int position = Integer.parseInt(args[1]);
                    ArrayList<PlayerScoreEntry> scoreboardEntries = new ArrayList<PlayerScoreEntry>(scoreboard.listPlayerScores(scoreboardObjective));
                    scoreboardEntries.sort(Comparator.comparingInt(PlayerScoreEntry::value));
                    PlayerScoreEntry scoreboardEntry = (PlayerScoreEntry)scoreboardEntries.get(position - 1);
                    return PlaceholderResult.value((String)String.valueOf(scoreboardEntry.value()));
                }
                catch (Exception e) {
                    return PlaceholderResult.invalid((String)"Invalid position!");
                }
            }
            return PlaceholderResult.invalid((String)"Not enough arguments!");
        });
    }
}

