/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.schedule;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.lovetropics.extras.ExtrasConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.util.ExtraCodecs;
import org.slf4j.Logger;

public record StreamSchedule(List<Entry> entries) {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().executor((Executor)Util.ioPool()).connectTimeout(Duration.ofSeconds(10L)).build();
    public static final Codec<StreamSchedule> CODEC = RecordCodecBuilder.create(i -> i.group((App)Entry.CODEC.listOf().fieldOf("schedule_entries").forGetter(StreamSchedule::entries)).apply((Applicative)i, StreamSchedule::new));

    public static CompletableFuture<Optional<StreamSchedule>> fetch() {
        String authKey = (String)ExtrasConfig.TECH_STACK.authKey.get();
        if (authKey.isEmpty()) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        HttpRequest request = HttpRequest.newBuilder(URI.create((String)ExtrasConfig.TECH_STACK.scheduleUrl.get())).header("Authorization", "Bearer " + authKey).header("User-Agent", "LTExtras 1.0 (lovetropics.org)").header("Content-Type", "application/json").GET().build();
        return ((CompletableFuture)HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApplyAsync(response -> {
            JsonElement json = JsonParser.parseString((String)((String)response.body()));
            return CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(Util.prefix((String)"Failed to parse stream schedule: ", arg_0 -> ((Logger)LOGGER).error(arg_0)));
        }, (Executor)Util.backgroundExecutor())).exceptionally(throwable -> {
            LOGGER.error("Failed to fetch stream schedule", throwable);
            return Optional.empty();
        });
    }

    @Nullable
    public Entry currentAt(Instant time) {
        for (Entry entry : this.entries) {
            if (entry.startTime().isAfter(time) || time.isAfter(entry.endTime())) continue;
            return entry;
        }
        return null;
    }

    @Nullable
    public Entry nextAfter(Instant time) {
        for (Entry entry : this.entries) {
            if (!entry.startTime().isAfter(time)) continue;
            return entry;
        }
        return null;
    }

    public record Entry(String description, Optional<URI> imageUrl, Instant startTime, Instant endTime, List<Host> hosts) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("desc").forGetter(Entry::description), (App)ExtraCodecs.UNTRUSTED_URI.lenientOptionalFieldOf("image_url").forGetter(Entry::imageUrl), (App)ExtraCodecs.INSTANT_ISO8601.fieldOf("start_time").forGetter(Entry::startTime), (App)ExtraCodecs.INSTANT_ISO8601.fieldOf("end_time").forGetter(Entry::endTime), (App)Host.CODEC.listOf().fieldOf("hosts").forGetter(Entry::hosts)).apply((Applicative)i, Entry::new));
    }

    public record Host(String name) {
        public static final Codec<Host> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("name").forGetter(Host::name)).apply((Applicative)i, Host::new));
    }
}

