/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.techstack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.lovetropics.extras.LTExtras;
import com.lovetropics.lib.slideshow.SlideshowApi;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.LenientJsonParser;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.slf4j.Logger;

public class VideoImporter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final VideoImporter INSTANCE = new VideoImporter();
    private final Path storeFile;
    private final List<ImportedVideo> importedVideos = new ArrayList<ImportedVideo>();
    private final ConsecutiveExecutor executor = new ConsecutiveExecutor((Executor)Util.ioPool(), "lt-video-importer");

    private VideoImporter() {
        this.storeFile = FMLPaths.MODSDIR.get().resolve("lovetropics").resolve("imported_videos.json");
        this.executor.schedule(() -> {
            if (!Files.exists(this.storeFile, new LinkOption[0])) {
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(this.storeFile);){
                JsonElement json = LenientJsonParser.parse((Reader)reader);
                this.importedVideos.addAll((Collection)ImportedVideo.CODEC.listOf().parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(JsonSyntaxException::new));
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                LOGGER.error("Failed to load imported videos", e);
            }
        });
    }

    public static VideoImporter get() {
        return INSTANCE;
    }

    public void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        this.executor.schedule(() -> {
            List<ImportedVideo> importedVideos = List.copyOf(this.importedVideos);
            server.execute(() -> {
                for (ImportedVideo video : importedVideos) {
                    SlideshowApi.importSimpleVideo((ResourceLocation)video.id, (URI)video.url, (double)video.duration);
                }
            });
        });
    }

    public void importVideo(String title, URI url, double duration) {
        ResourceLocation id = VideoImporter.toVideoId(title);
        LOGGER.info("Importing video with id {} from {} and duration of {} seconds", new Object[]{id, url, duration});
        SlideshowApi.importSimpleVideo((ResourceLocation)id, (URI)url, (double)duration);
        this.executor.schedule(() -> {
            this.importedVideos.add(new ImportedVideo(id, url, duration));
            try {
                Files.createDirectories(this.storeFile.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(this.storeFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                    JsonElement json = (JsonElement)ImportedVideo.CODEC.listOf().encodeStart((DynamicOps)JsonOps.INSTANCE, this.importedVideos).getOrThrow();
                    GSON.toJson(json, (Appendable)writer);
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to write imported videos", (Throwable)e);
            }
        });
    }

    private static ResourceLocation toVideoId(String title) {
        StringBuilder id = new StringBuilder();
        title.chars().forEach(c -> {
            char ch = Character.toLowerCase((char)c);
            if (Character.isLetterOrDigit(ch)) {
                id.append(ch);
            } else {
                id.append('_');
            }
        });
        return LTExtras.location(id.toString());
    }

    private record ImportedVideo(ResourceLocation id, URI url, double duration) {
        public static final Codec<ImportedVideo> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(ImportedVideo::id), (App)ExtraCodecs.UNTRUSTED_URI.fieldOf("url").forGetter(ImportedVideo::url), (App)Codec.DOUBLE.fieldOf("duration").forGetter(ImportedVideo::duration)).apply((Applicative)i, ImportedVideo::new));
    }
}

