/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.translation;

import com.lovetropics.extras.ExtraLangKeys;
import com.lovetropics.extras.ExtrasConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CommonButtons;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.LanguageSelectScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class TranslationPromptScreen
extends Screen {
    private static final Component TITLE = ExtraLangKeys.TRANSLATION_PROMPT_TITLE.get();
    private static final Component MESSAGE = ExtraLangKeys.TRANSLATION_PROMPT.get();
    private static final int MAX_WIDTH = 300;
    private final Runnable callback;
    private final LinearLayout layout = LinearLayout.vertical().spacing(8);

    public TranslationPromptScreen(Runnable callback, Minecraft minecraft, Font font) {
        super(TITLE);
        this.callback = callback;
        this.layout.defaultCellSetting().alignHorizontallyCenter();
        this.layout.addChild((LayoutElement)new StringWidget(TITLE, font).alignCenter(), this.layout.newCellSettings().paddingVertical(10));
        this.layout.addChild((LayoutElement)new MultiLineTextWidget(MESSAGE, font).setCentered(true).setMaxWidth(300));
        this.layout.addChild((LayoutElement)CommonButtons.language((int)150, button -> minecraft.setScreen((Screen)new LanguageSelectScreen((Screen)this, minecraft.options, minecraft.getLanguageManager())), (boolean)false));
        this.layout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, b -> this.onClose()).build(), this.layout.newCellSettings().paddingVertical(10));
    }

    protected void init() {
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }

    public Component getNarrationMessage() {
        return CommonComponents.joinForNarration((Component[])new Component[]{TITLE, MESSAGE});
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public void onClose() {
        ExtrasConfig.TRANSLATION.prompted.set((Object)true);
        ExtrasConfig.CLIENT_CONFIG.save();
        this.callback.run();
    }
}

