/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.world_effect;

import com.lovetropics.extras.network.message.ClientboundWorldParticleEffectsPacket;
import com.lovetropics.extras.world_effect.WorldEffect;
import com.lovetropics.extras.world_effect.WorldEffectType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public record ParticlesEffect(List<Particle> particles) implements WorldEffect
{
    public static final MapCodec<ParticlesEffect> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Particle.CODEC.listOf().fieldOf("particles").forGetter(ParticlesEffect::particles)).apply((Applicative)i, ParticlesEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ParticlesEffect> STREAM_CODEC = StreamCodec.composite((StreamCodec)Particle.STREAM_CODEC.apply(ByteBufCodecs.list()), ParticlesEffect::particles, ParticlesEffect::new);

    @Override
    public void apply(ServerPlayer player, boolean immediate) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundWorldParticleEffectsPacket(Optional.of(this)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void clear(ServerPlayer player, boolean immediate) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundWorldParticleEffectsPacket(Optional.empty()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public WorldEffectType type() {
        return WorldEffectType.PARTICLES;
    }

    public record Particle(ParticleOptions particle, int count, int range, Vec3i offset) {
        public static final Codec<Particle> CODEC = RecordCodecBuilder.create(i -> i.group((App)ParticleTypes.CODEC.fieldOf("options").forGetter(Particle::particle), (App)Codec.INT.fieldOf("count").forGetter(Particle::count), (App)Codec.INT.fieldOf("range").forGetter(Particle::range), (App)Vec3i.CODEC.optionalFieldOf("offset", (Object)BlockPos.ZERO).forGetter(Particle::offset)).apply((Applicative)i, Particle::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Particle> STREAM_CODEC = StreamCodec.composite((StreamCodec)ParticleTypes.STREAM_CODEC, Particle::particle, (StreamCodec)ByteBufCodecs.VAR_INT, Particle::count, (StreamCodec)ByteBufCodecs.VAR_INT, Particle::range, (StreamCodec)BlockPos.STREAM_CODEC.map(Function.identity(), BlockPos::new), Particle::offset, Particle::new);
    }
}

