/*
 * Decompiled with CFR 0.152.
 */
package com.lovetropics.extras.world_effect;

import com.lovetropics.extras.data.Named;
import com.lovetropics.extras.world_effect.WorldEffect;
import com.lovetropics.extras.world_effect.WorldEffectConfigs;
import com.lovetropics.extras.world_effect.WorldEffectManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;

public class WorldEffectCommand {
    private static final DynamicCommandExceptionType WORLD_EFFECT_CONFIG_NOT_FOUND = new DynamicCommandExceptionType(id -> Component.literal((String)("World effect does not exist with id: " + String.valueOf(id))));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"worldeffect").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"apply").then(((RequiredArgumentBuilder)WorldEffectCommand.effectArgument("effect").executes(context -> WorldEffectCommand.apply((CommandContext<CommandSourceStack>)context, WorldEffectCommand.getEffect((CommandContext<CommandSourceStack>)context, "effect"), Long.MAX_VALUE))).then(Commands.argument((String)"duration", (ArgumentType)TimeArgument.time()).executes(context -> WorldEffectCommand.apply((CommandContext<CommandSourceStack>)context, WorldEffectCommand.getEffect((CommandContext<CommandSourceStack>)context, "effect"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear").then(WorldEffectCommand.effectArgument("effect").executes(context -> WorldEffectCommand.clear((CommandContext<CommandSourceStack>)context, WorldEffectCommand.getEffect((CommandContext<CommandSourceStack>)context, "effect"))))).executes(WorldEffectCommand::clearAll)));
    }

    private static int apply(CommandContext<CommandSourceStack> context, Named<WorldEffect> effect, long duration) {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        long expiresAt = duration == Long.MAX_VALUE ? Long.MAX_VALUE : server.overworld().getGameTime() + duration;
        WorldEffectManager.apply(((CommandSourceStack)context.getSource()).getLevel(), effect, expiresAt);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Applied world effect: " + String.valueOf(effect.id()))), false);
        return 1;
    }

    private static int clear(CommandContext<CommandSourceStack> context, Named<WorldEffect> effect) {
        WorldEffectManager.clear(((CommandSourceStack)context.getSource()).getLevel(), effect.id());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Cleared world effect: " + String.valueOf(effect.id()))), false);
        return 1;
    }

    private static int clearAll(CommandContext<CommandSourceStack> context) {
        WorldEffectManager.clearAll(((CommandSourceStack)context.getSource()).getLevel());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Cleared all world effects"), false);
        return 1;
    }

    public static RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> effectArgument(String name) {
        return Commands.argument((String)name, (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> SharedSuggestionProvider.suggestResource(WorldEffectConfigs.REGISTRY.stream().map(Named::id), (SuggestionsBuilder)builder));
    }

    private static Named<WorldEffect> getEffect(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocationArgument.getId(context, (String)name);
        Named config = (Named)WorldEffectConfigs.REGISTRY.get((Object)id);
        if (config == null) {
            throw WORLD_EFFECT_CONFIG_NOT_FOUND.create((Object)id);
        }
        return config;
    }
}

