/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.dummyplayers.client.renderer.dummy;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tterrag.dummyplayers.client.renderer.dummy.DummyPlayerModel;
import com.tterrag.dummyplayers.client.renderer.dummy.DummyPlayerRenderState;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerCapeModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;

public class DummyCapeLayer
extends RenderLayer<DummyPlayerRenderState, DummyPlayerModel> {
    private final HumanoidModel<PlayerRenderState> model;
    private final EquipmentAssetManager equipmentAssets;

    public DummyCapeLayer(RenderLayerParent<DummyPlayerRenderState, DummyPlayerModel> parent, EntityModelSet modelSet, EquipmentAssetManager equipmentAssets) {
        super(parent);
        this.model = new PlayerCapeModel(modelSet.bakeLayer(ModelLayers.PLAYER_CAPE));
        this.equipmentAssets = equipmentAssets;
    }

    private boolean hasLayer(ItemStack stack, EquipmentClientInfo.LayerType layer) {
        Equippable equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE);
        if (equippable == null || equippable.assetId().isEmpty()) {
            return false;
        }
        EquipmentClientInfo info = this.equipmentAssets.get((ResourceKey)equippable.assetId().get());
        return !info.getLayers(layer).isEmpty();
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, DummyPlayerRenderState state, float yRot, float xRot) {
        ResourceLocation capeTexture = state.skin.capeTexture();
        if (state.isInvisible || capeTexture == null) {
            return;
        }
        if (this.hasLayer(state.chestEquipment, EquipmentClientInfo.LayerType.WINGS)) {
            return;
        }
        poseStack.pushPose();
        if (this.hasLayer(state.chestEquipment, EquipmentClientInfo.LayerType.HUMANOID)) {
            poseStack.translate(0.0f, -0.053125f, 0.06875f);
        }
        this.model.body.copyFrom(((DummyPlayerModel)this.getParentModel()).body);
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)capeTexture)), packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

