/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.dummyplayers.client.renderer.dummy;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tterrag.dummyplayers.client.renderer.dummy.DummyPlayerModel;
import com.tterrag.dummyplayers.client.renderer.dummy.DummyPlayerRenderState;
import javax.annotation.Nullable;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;

public class DummyElytraLayer
extends RenderLayer<DummyPlayerRenderState, DummyPlayerModel> {
    private final ElytraModel model;
    private final EquipmentLayerRenderer equipmentRenderer;

    public DummyElytraLayer(RenderLayerParent<DummyPlayerRenderState, DummyPlayerModel> parent, EntityModelSet models, EquipmentLayerRenderer equipmentRenderer) {
        super(parent);
        this.model = new ElytraModel(models.bakeLayer(ModelLayers.ELYTRA));
        this.equipmentRenderer = equipmentRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, DummyPlayerRenderState state, float yRot, float xRot) {
        ItemStack chestEquipment = state.chestEquipment;
        Equippable equippable = (Equippable)chestEquipment.get(DataComponents.EQUIPPABLE);
        if (equippable == null || equippable.assetId().isEmpty()) {
            return;
        }
        ResourceLocation texture = DummyElytraLayer.getTextureOverride(state);
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 0.125f);
        this.model.setupAnim((HumanoidRenderState)state);
        this.equipmentRenderer.renderLayers(EquipmentClientInfo.LayerType.WINGS, (ResourceKey)equippable.assetId().get(), (Model)this.model, chestEquipment, poseStack, bufferSource, packedLight, texture);
        poseStack.popPose();
    }

    @Nullable
    private static ResourceLocation getTextureOverride(DummyPlayerRenderState state) {
        PlayerSkin skin = state.skin;
        if (skin.elytraTexture() != null) {
            return skin.elytraTexture();
        }
        if (skin.capeTexture() != null) {
            return skin.capeTexture();
        }
        return null;
    }
}

