/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.dummyplayers.client.renderer.dummy;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tterrag.dummyplayers.client.renderer.dummy.DummyArmorLayer;
import com.tterrag.dummyplayers.client.renderer.dummy.DummyCapeLayer;
import com.tterrag.dummyplayers.client.renderer.dummy.DummyElytraLayer;
import com.tterrag.dummyplayers.client.renderer.dummy.DummyPlayerModel;
import com.tterrag.dummyplayers.client.renderer.dummy.DummyPlayerRenderState;
import com.tterrag.dummyplayers.client.renderer.dummy.DummyStandLayer;
import com.tterrag.dummyplayers.entity.DummyPlayerEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class DummyPlayerEntityRenderer
extends LivingEntityRenderer<DummyPlayerEntity, DummyPlayerRenderState, DummyPlayerModel> {
    private final DummyPlayerModel slim;
    private final DummyPlayerModel normal;

    public DummyPlayerEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new DummyPlayerModel(context.bakeLayer(ModelLayers.PLAYER)), 0.0f);
        this.normal = (DummyPlayerModel)this.model;
        this.slim = new DummyPlayerModel(context.bakeLayer(ModelLayers.PLAYER_SLIM));
        this.addLayer(new DummyStandLayer((RenderLayerParent<DummyPlayerRenderState, DummyPlayerModel>)this, context.getModelSet()));
        this.addLayer(new DummyArmorLayer(this, new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new DummyPlayerModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), (HumanoidModel)new DummyPlayerModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getEquipmentRenderer()), new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new DummyPlayerModel(context.bakeLayer(ModelLayers.PLAYER_SLIM_INNER_ARMOR)), (HumanoidModel)new DummyPlayerModel(context.bakeLayer(ModelLayers.PLAYER_SLIM_OUTER_ARMOR)), context.getEquipmentRenderer())));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        this.addLayer(new DummyCapeLayer((RenderLayerParent<DummyPlayerRenderState, DummyPlayerModel>)this, context.getModelSet(), context.getEquipmentAssets()));
        this.addLayer(new DummyElytraLayer((RenderLayerParent<DummyPlayerRenderState, DummyPlayerModel>)this, context.getModelSet(), context.getEquipmentRenderer()));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet()));
    }

    public DummyPlayerRenderState createRenderState() {
        return new DummyPlayerRenderState();
    }

    public void extractRenderState(DummyPlayerEntity entity, DummyPlayerRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, partialTicks);
        HumanoidMobRenderer.extractHumanoidRenderState((LivingEntity)entity, (HumanoidRenderState)state, (float)partialTicks, (ItemModelResolver)this.itemModelResolver);
        state.skin = entity.clientData().skin();
        state.headPose = entity.getHeadPose();
        state.bodyPose = entity.getBodyPose();
        state.leftArmPose = entity.getLeftArmPose();
        state.rightArmPose = entity.getRightArmPose();
        state.leftLegPose = entity.getLeftLegPose();
        state.rightLegPose = entity.getRightLegPose();
        state.showBasePlate = entity.showBasePlate();
    }

    public void render(DummyPlayerRenderState state, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        this.model = switch (state.skin.model()) {
            default -> throw new MatchException(null, null);
            case PlayerSkin.Model.WIDE -> this.normal;
            case PlayerSkin.Model.SLIM -> this.slim;
        };
        super.render((LivingEntityRenderState)state, poseStack, bufferSource, packedLight);
    }

    protected boolean shouldShowName(DummyPlayerEntity entity, double distanceSq) {
        return entity.getProfile().name().isPresent() || entity.hasCustomName();
    }

    protected void scale(DummyPlayerRenderState state, PoseStack poseStack) {
        if (state.showBasePlate) {
            poseStack.translate(0.0f, -0.0625f, 0.0f);
        }
        float scale = 0.9375f;
        poseStack.scale(scale, scale, scale);
    }

    public ResourceLocation getTextureLocation(DummyPlayerRenderState state) {
        return state.skin.texture();
    }
}

