/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.dummyplayers.client.renderer.dummy;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tterrag.dummyplayers.DummyPlayers;
import com.tterrag.dummyplayers.client.renderer.dummy.DummyPlayerModel;
import com.tterrag.dummyplayers.client.renderer.dummy.DummyPlayerRenderState;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;

public class DummyStandLayer
extends RenderLayer<DummyPlayerRenderState, DummyPlayerModel> {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(DummyPlayers.DUMMY_PLAYER.getId(), "stand");
    private final Model standModel;
    private final ModelPart standBase;

    public DummyStandLayer(RenderLayerParent<DummyPlayerRenderState, DummyPlayerModel> parent, EntityModelSet context) {
        super(parent);
        this.standBase = context.bakeLayer(LAYER);
        this.standModel = new Model.Simple(this.standBase, RenderType::entitySolid);
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("base_plate", CubeListBuilder.create().texOffs(0, 32).addBox(-6.0f, 11.0f, -6.0f, 12.0f, 1.0f, 12.0f), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, DummyPlayerRenderState state, float yRot, float xRot) {
        if (!state.showBasePlate) {
            return;
        }
        this.standBase.yRot = (float)Math.PI / 180 * -yRot;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0625f, 0.0f);
        this.standModel.renderToBuffer(poseStack, bufferSource.getBuffer(this.standModel.renderType(ArmorStandRenderer.DEFAULT_SKIN_LOCATION)), packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

