/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.dummyplayers.commands;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.tterrag.dummyplayers.DummyPlayers;
import com.tterrag.dummyplayers.entity.DummyPlayerEntity;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.entity.SkullBlockEntity;

public class DummyPlayersCommand {
    private static final SimpleCommandExceptionType ONLY_DUMMIES = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.dummyplayer.only_dummies"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dummyplayer").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"spawn").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"profile", (ArgumentType)GameProfileArgument.gameProfile()).executes(DummyPlayersCommand::spawnDummyPlayer))))).then(Commands.literal((String)"modify").then(Commands.argument((String)"dummy", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"profile", (ArgumentType)GameProfileArgument.gameProfile()).executes(DummyPlayersCommand::modifyDummyProfile)))));
    }

    private static int modifyDummyProfile(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(ctx, (String)"dummy");
        Collection profiles = GameProfileArgument.getGameProfiles(ctx, (String)"profile");
        if (!(entity instanceof DummyPlayerEntity)) {
            throw ONLY_DUMMIES.create();
        }
        DummyPlayerEntity dummy = (DummyPlayerEntity)entity;
        DummyPlayersCommand.resolveProfile(profiles).thenAccept(resolvableProfile -> {
            dummy.setAndFillProfile((ResolvableProfile)resolvableProfile);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.dummyplayer.modified_dummy"), true);
        });
        return 1;
    }

    private static int spawnDummyPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getBlockPos(ctx, (String)"pos");
        Collection profiles = GameProfileArgument.getGameProfiles(ctx, (String)"profile");
        DummyPlayersCommand.resolveProfile(profiles).thenAccept(resolvableProfile -> {
            ServerLevel serverLevel = ((CommandSourceStack)ctx.getSource()).getLevel();
            DummyPlayerEntity dummy = (DummyPlayerEntity)((EntityType)DummyPlayers.DUMMY_PLAYER.get()).create(serverLevel, dummyPlayerEntity -> dummyPlayerEntity.setAndFillProfile((ResolvableProfile)resolvableProfile), pos, EntitySpawnReason.SPAWN_ITEM_USE, true, true);
            serverLevel.addFreshEntityWithPassengers((Entity)dummy);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.dummyplayer.spawned_profile"), true);
        });
        return 1;
    }

    private static CompletableFuture<ResolvableProfile> resolveProfile(Collection<GameProfile> profiles) throws CommandSyntaxException {
        if (profiles.size() != 1) {
            throw EntityArgument.ERROR_NOT_SINGLE_PLAYER.create();
        }
        GameProfile profile = (GameProfile)Iterables.getOnlyElement(profiles);
        return SkullBlockEntity.fetchGameProfile((UUID)profile.getId()).thenApply(optional -> new ResolvableProfile(optional.orElse(profile)));
    }

    public static void addTranslations(RegistrateLangProvider provider) {
        provider.add("commands.dummyplayer.only_dummies", "Only Dummy Players entities can be modified");
        provider.add("commands.dummyplayer.spawned_profile", "Spawn Dummy Player with profile");
        provider.add("commands.dummyplayer.modified_dummy", "Modified Dummy Player profile");
    }
}

