/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.dummyplayers.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.logging.LogUtils;
import com.tterrag.dummyplayers.DummyPlayers;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public class DummyPlayerEntity
extends ArmorStand {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<ResolvableProfile> GAME_PROFILE = SynchedEntityData.defineId(DummyPlayerEntity.class, (EntityDataSerializer)((EntityDataSerializer)DummyPlayers.PROFILE_SERIALIZER.get()));
    private static final EntityDataAccessor<Optional<Component>> PREFIX = SynchedEntityData.defineId(DummyPlayerEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_COMPONENT);
    private static final EntityDataAccessor<Optional<Component>> SUFFIX = SynchedEntityData.defineId(DummyPlayerEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_COMPONENT);
    private static final ResolvableProfile NO_PROFILE = new ResolvableProfile(Optional.empty(), Optional.empty(), new PropertyMap());
    @Nullable
    private ClientData clientData;

    public DummyPlayerEntity(EntityType<? extends DummyPlayerEntity> type, Level level) {
        super(type, level);
        if (!level.isClientSide()) {
            this.entityData.set(DATA_CLIENT_FLAGS, (Object)4);
        } else {
            this.clientData = new ClientData();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(GAME_PROFILE, (Object)NO_PROFILE);
        builder.define(PREFIX, Optional.empty());
        builder.define(SUFFIX, Optional.empty());
    }

    public Component getTypeName() {
        return this.getProfile().name().isEmpty() ? super.getTypeName() : Component.literal((String)((String)this.getProfile().name().get()));
    }

    public Component getDisplayName() {
        MutableComponent ret = super.getDisplayName().copy();
        Component prefix = ((Optional)this.entityData.get(PREFIX)).orElse(null);
        Component suffix = ((Optional)this.entityData.get(SUFFIX)).orElse(null);
        if (prefix != null) {
            ret = prefix.copy().append((Component)ret);
        }
        if (suffix != null) {
            ret = ret.append((Component)suffix.copy());
        }
        return ret;
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)DummyPlayers.SPAWNER.get());
    }

    public ResolvableProfile getProfile() {
        return (ResolvableProfile)this.entityData.get(GAME_PROFILE);
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        ((Optional)this.entityData.get(PREFIX)).ifPresent(prefix -> output.store("name_prefix", ComponentSerialization.CODEC, prefix));
        ((Optional)this.entityData.get(SUFFIX)).ifPresent(suffix -> output.store("name_suffix", ComponentSerialization.CODEC, suffix));
        output.store("profile", ResolvableProfile.CODEC, (Object)this.getProfile());
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.entityData.set(PREFIX, input.read("name_prefix", ComponentSerialization.CODEC).map(this::resolveComponent));
        this.entityData.set(SUFFIX, input.read("name_suffix", ComponentSerialization.CODEC).map(this::resolveComponent));
        this.setAndFillProfile(input.read("profile", ResolvableProfile.CODEC).orElse(NO_PROFILE));
    }

    private Component resolveComponent(Component component) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            try {
                CommandSourceStack source = this.createCommandSourceStackForNameResolution(serverLevel).withPermission(2);
                return ComponentUtils.updateForEntity((CommandSourceStack)source, (Component)component, (Entity)this, (int)0);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to resolve dummy entity text {}", (Object)component, (Object)e);
            }
        }
        return component;
    }

    public void setAndFillProfile(ResolvableProfile profile) {
        ResolvableProfile oldProfile = this.getProfile();
        if (profile.name().equals(oldProfile.name()) && profile.id().equals(oldProfile.id())) {
            return;
        }
        this.entityData.set(GAME_PROFILE, (Object)profile);
        this.fillProfile();
    }

    void fillProfile() {
        if (this.getProfile().isResolved()) {
            return;
        }
        this.getProfile().resolve().thenAcceptAsync(resolvedProfile -> this.entityData.set(GAME_PROFILE, resolvedProfile), SkullBlockEntity.CHECKED_MAIN_THREAD_EXECUTOR);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (GAME_PROFILE.equals(key) && this.clientData != null) {
            this.clientData.invalidate();
        }
    }

    public ClientData clientData() {
        return Objects.requireNonNull(this.clientData, "Cannot access client data on server");
    }

    public class ClientData {
        private Supplier<PlayerSkin> skinLookup = () -> DefaultPlayerSkin.get((UUID)DummyPlayerEntity.this.getUUID());
        private boolean reloadTextures = true;

        public void invalidate() {
            this.reloadTextures = true;
        }

        private static Supplier<PlayerSkin> createSkinLookup(ResolvableProfile profile, UUID fallbackUuid) {
            PlayerSkin defaultSkin = DefaultPlayerSkin.get((UUID)profile.id().orElse(fallbackUuid));
            if (profile.properties().isEmpty()) {
                return () -> defaultSkin;
            }
            return ClientData.createSkinLookup(profile.gameProfile(), defaultSkin);
        }

        private static Supplier<PlayerSkin> createSkinLookup(GameProfile profile, PlayerSkin defaultSkin) {
            CompletableFuture skinFuture = Minecraft.getInstance().getSkinManager().getOrLoad(profile);
            if (skinFuture.isDone()) {
                PlayerSkin skin = skinFuture.getNow(Optional.empty()).orElse(defaultSkin);
                return () -> skin;
            }
            return () -> skinFuture.getNow(Optional.empty()).orElse(defaultSkin);
        }

        public PlayerSkin skin() {
            if (this.reloadTextures) {
                this.reloadTextures = false;
                this.skinLookup = ClientData.createSkinLookup(DummyPlayerEntity.this.getProfile(), DummyPlayerEntity.this.getUUID());
            }
            return this.skinLookup.get();
        }
    }
}

