/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.tropicraft.core.client.entity.model.ModelAnimator;
import net.tropicraft.core.client.entity.render.state.BasiliskLizardRenderState;

public class BasiliskLizardModel
extends EntityModel<BasiliskLizardRenderState> {
    private static final float BACK_LEG_ANGLE = 1.134464f;
    private static final float FRONT_LEG_ANGLE = -0.6981317f;
    private final ModelPart body_base;
    private final ModelPart leg_back_left;
    private final ModelPart leg_front_left;
    private final ModelPart head_base;
    private final ModelPart tail_base;
    private final ModelPart tail_tip;
    private final ModelPart leg_back_right;
    private final ModelPart leg_front_right;

    public BasiliskLizardModel(ModelPart root) {
        super(root);
        this.body_base = root.getChild("body_base");
        this.leg_back_left = this.body_base.getChild("leg_back_left");
        this.leg_front_left = this.body_base.getChild("leg_front_left");
        this.head_base = this.body_base.getChild("head_base");
        this.tail_base = this.body_base.getChild("tail_base");
        this.tail_tip = this.tail_base.getChild("tail_tip");
        this.leg_back_right = this.body_base.getChild("leg_back_right");
        this.leg_front_right = this.body_base.getChild("leg_front_right");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body_base", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -5.0f, 2.0f, 2.0f, 6.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)22.5f, (float)1.6f, (float)-0.2617994f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("sail_back", CubeListBuilder.create().texOffs(0, 9).addBox(0.0f, -2.0f, 0.0f, 0.0f, 2.0f, 6.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-5.0f, (float)-0.04363323f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("leg_back_left", CubeListBuilder.create().texOffs(5, 25).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, false), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)1.134464f, (float)0.0f, (float)-1.3526301f));
        body.addOrReplaceChild("leg_front_left", CubeListBuilder.create().texOffs(15, 25).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f, false), PartPose.offsetAndRotation((float)1.0f, (float)0.5f, (float)-4.0f, (float)-0.6981317f, (float)0.6981317f, (float)-1.0035644f));
        PartDefinition modelPartHead = body.addOrReplaceChild("head_base", CubeListBuilder.create().mirror(false).texOffs(0, 18).addBox(-1.0f, -1.0f, -3.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-5.0f, (float)0.1308997f, (float)0.0f, (float)0.0f));
        modelPartHead.addOrReplaceChild("sail_head", CubeListBuilder.create().texOffs(20, 18).addBox(0.0f, -3.0f, 0.0f, 0.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-2.0f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        PartDefinition modelPartTail = body.addOrReplaceChild("tail_base", CubeListBuilder.create().texOffs(13, 9).addBox(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)1.0f, (float)0.08726646f, (float)0.0f, (float)0.0f));
        modelPartTail.addOrReplaceChild("sail_tail", CubeListBuilder.create().texOffs(11, 18).addBox(0.0f, -2.0f, 0.0f, 0.0f, 2.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.04363323f, (float)0.0f, (float)0.0f));
        modelPartTail.addOrReplaceChild("tail_tip", CubeListBuilder.create().texOffs(17, 0).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 1.0f, 6.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)4.0f, (float)0.08726646f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("leg_back_right", CubeListBuilder.create().texOffs(0, 25).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f, false), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)1.134464f, (float)0.0f, (float)1.3526301f));
        body.addOrReplaceChild("leg_front_right", CubeListBuilder.create().texOffs(10, 25).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 3.0f, 1.0f, false), PartPose.offsetAndRotation((float)-1.0f, (float)0.5f, (float)-4.0f, (float)-0.6981317f, (float)-0.6981317f, (float)1.0035644f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void setupAnim(BasiliskLizardRenderState state) {
        super.setupAnim((EntityRenderState)state);
        ModelAnimator.look(this.head_base, state);
        this.body_base.xRot = Mth.lerp((float)state.runningAnimation, (float)-15.0f, (float)-50.0f) * ((float)Math.PI / 180);
        this.tail_base.xRot = Mth.lerp((float)state.runningAnimation, (float)5.0f, (float)30.0f) * ((float)Math.PI / 180);
        this.tail_tip.xRot = Mth.lerp((float)state.runningAnimation, (float)5.0f, (float)20.0f) * ((float)Math.PI / 180);
        this.head_base.xRot = Mth.lerp((float)state.runningAnimation, (float)7.5f, (float)35.0f) * ((float)Math.PI / 180);
        try (ModelAnimator.Cycle walk = ModelAnimator.cycle(state.walkAnimationPos * 0.25f, state.walkAnimationSpeed);){
            this.leg_front_left.xRot = -0.6981317f + walk.eval(-1.0f, 1.0f, 0.0f, 1.0f);
            this.leg_front_right.xRot = -0.6981317f + walk.eval(1.0f, 1.0f, 0.0f, 1.0f);
            this.leg_back_left.xRot = 1.134464f + walk.eval(-1.0f, -0.9f, 0.0f, -0.9f);
            this.leg_back_right.xRot = 1.134464f + walk.eval(1.0f, -0.9f, 0.0f, -0.9f);
            this.body_base.xRot += walk.eval(0.5f, state.runningAnimation * 0.1f);
        }
    }
}

