/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;

public class FailgullModel
extends EntityModel<LivingEntityRenderState> {
    private static final float WING_ROT_BASE = 1.5707964f;
    private static final float LEFT_WING_ZROT = 1.6231562f;
    private static final float RIGHT_WING_ZROT = 1.5184364f;
    private final ModelPart lowerLeg1;
    private final ModelPart lowerLeg2;
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public FailgullModel(ModelPart root) {
        super(root);
        this.lowerLeg1 = root.getChild("lowerLeg1");
        this.lowerLeg2 = root.getChild("lowerLeg2");
        this.rightWing = root.getChild("rightWing");
        this.leftWing = root.getChild("leftWing");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("baseFootLeft", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.001f)), PartPose.offset((float)-1.0f, (float)23.0f, (float)0.0f));
        root.addOrReplaceChild("baseFootRight", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.001f)), PartPose.offset((float)1.0f, (float)23.0f, (float)0.0f));
        root.addOrReplaceChild("lowerLeg1", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -1.0f, 0.0f, 1.0f, 2.0f, 0.0f), PartPose.offset((float)1.0f, (float)22.0f, (float)1.0f));
        root.addOrReplaceChild("lowestBody", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 3.0f, 1.0f, 4.0f), PartPose.offset((float)-1.0f, (float)20.0f, (float)0.0f));
        root.addOrReplaceChild("lowerLeg2", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f), PartPose.offset((float)-1.0f, (float)21.0f, (float)1.0f));
        root.addOrReplaceChild("lowerBody1", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 3.0f, 1.0f, 8.0f), PartPose.offset((float)-1.0f, (float)19.0f, (float)-1.0f));
        root.addOrReplaceChild("lowerBody2", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 3.0f, 1.0f, 7.0f), PartPose.offset((float)-1.0f, (float)18.0f, (float)-2.0f));
        root.addOrReplaceChild("rightWing", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.002f)), PartPose.offsetAndRotation((float)-1.0f, (float)18.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f, (float)1.5184364f));
        root.addOrReplaceChild("leftWing", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.002f)), PartPose.offsetAndRotation((float)2.0f, (float)18.0f, (float)-2.0f, (float)1.5707964f, (float)0.0f, (float)1.6231562f));
        root.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 3.0f, 2.0f, 2.0f), PartPose.offset((float)-1.0f, (float)16.0f, (float)-3.0f));
        root.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(14, 0).addBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 2.0f), PartPose.offset((float)0.0f, (float)17.0f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void setupAnim(LivingEntityRenderState state) {
        super.setupAnim((EntityRenderState)state);
        this.lowerLeg1.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f)) * 1.4f * state.walkAnimationSpeed;
        this.lowerLeg2.xRot = Mth.cos((float)(state.walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.4f * state.walkAnimationSpeed;
        this.rightWing.zRot = 1.5184364f + Mth.sin((float)(state.ageInTicks * 0.4f)) / 2.0f;
        this.leftWing.zRot = 1.6231562f - Mth.sin((float)(state.ageInTicks * 0.4f)) / 2.0f;
    }
}

