/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.tropicraft.core.client.entity.model.ModelAnimator;
import net.tropicraft.core.client.entity.render.state.GibnutRenderState;

public class GibnutModel
extends EntityModel<GibnutRenderState> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart legBackLeft;
    private final ModelPart legBackRight;
    private final ModelPart legFrontLeft;
    private final ModelPart legFrontRight;
    private final ModelPart earLeft;
    private final ModelPart earRight;
    private final ModelPart whiskerLeft1;
    private final ModelPart whiskerLeft2;
    private final ModelPart whiskerRight1;
    private final ModelPart whiskerRight2;

    public GibnutModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body_base");
        this.head = this.body.getChild("head_base");
        this.legBackLeft = this.body.getChild("leg_back_left");
        this.legBackRight = this.body.getChild("leg_back_right");
        this.legFrontLeft = this.body.getChild("leg_front_left");
        this.legFrontRight = this.body.getChild("leg_front_right");
        this.earLeft = this.head.getChild("ear_left");
        this.earRight = this.head.getChild("ear_right");
        this.whiskerLeft1 = this.head.getChild("whisker_left1");
        this.whiskerLeft2 = this.head.getChild("whisker_left2");
        this.whiskerRight1 = this.head.getChild("whisker_right1");
        this.whiskerRight2 = this.head.getChild("whisker_right2");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body_base = partdefinition.addOrReplaceChild("body_base", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, -7.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)21.0f, (float)3.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition head_base = body_base.addOrReplaceChild("head_base", CubeListBuilder.create().texOffs(0, 13).addBox(-1.5f, -0.5f, -4.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-7.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition ear_right = head_base.addOrReplaceChild("ear_right", CubeListBuilder.create().texOffs(3, 31).addBox(-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-0.5f, (float)-0.75f, (float)-0.0289f, (float)0.2163f, (float)-0.3958f));
        PartDefinition ear_left = head_base.addOrReplaceChild("ear_left", CubeListBuilder.create().texOffs(0, 31).addBox(0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-0.5f, (float)-0.75f, (float)-0.0289f, (float)-0.2163f, (float)0.3958f));
        PartDefinition whisker_right1 = head_base.addOrReplaceChild("whisker_right1", CubeListBuilder.create(), PartPose.offset((float)-1.5f, (float)0.5f, (float)-4.0f));
        PartDefinition whisker_right1_r1 = whisker_right1.addOrReplaceChild("whisker_right1_r1", CubeListBuilder.create().texOffs(27, 29).addBox(-3.0f, 0.0f, 0.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.421f, (float)0.5574f, (float)-0.3532f));
        PartDefinition whisker_right2 = head_base.addOrReplaceChild("whisker_right2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.5f, (float)0.75f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        PartDefinition whisker_right2_r1 = whisker_right2.addOrReplaceChild("whisker_right2_r1", CubeListBuilder.create().texOffs(18, 29).addBox(-3.0f, 0.0f, 0.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.421f, (float)0.5574f, (float)-0.3532f));
        PartDefinition whisker_left1 = head_base.addOrReplaceChild("whisker_left1", CubeListBuilder.create(), PartPose.offset((float)-1.5f, (float)0.5f, (float)-4.0f));
        PartDefinition whisker_left1_r1 = whisker_left1.addOrReplaceChild("whisker_left1_r1", CubeListBuilder.create().texOffs(9, 29).addBox(0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)0.0f, (float)0.0f, (float)-0.421f, (float)-0.5574f, (float)0.3532f));
        PartDefinition whisker_left2 = head_base.addOrReplaceChild("whisker_left2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.5f, (float)0.75f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.3054f));
        PartDefinition whisker_left2_r1 = whisker_left2.addOrReplaceChild("whisker_left2_r1", CubeListBuilder.create().texOffs(0, 29).addBox(0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.421f, (float)-0.5574f, (float)0.3532f));
        PartDefinition leg_back_left = body_base.addOrReplaceChild("leg_back_left", CubeListBuilder.create().texOffs(15, 13).addBox(-0.5f, -0.5f, -1.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-1.5f, (float)-0.5f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition leg_back_right = body_base.addOrReplaceChild("leg_back_right", CubeListBuilder.create().texOffs(0, 21).addBox(-0.5f, -0.5f, -1.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-1.5f, (float)-0.5f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition leg_front_right = body_base.addOrReplaceChild("leg_front_right", CubeListBuilder.create().texOffs(14, 21).addBox(-0.5f, -1.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.75f, (float)-6.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leg_front_left = body_base.addOrReplaceChild("leg_front_left", CubeListBuilder.create().texOffs(7, 21).addBox(-0.5f, -1.0f, -1.0f, 1.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.75f, (float)-6.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createBaby() {
        return GibnutModel.create().apply(ModelAnimator.hierarchicalBaby("head_base", 0.5f));
    }

    public void setupAnim(GibnutRenderState state) {
        super.setupAnim((EntityRenderState)state);
        ModelAnimator.look(this.head, state);
        try (ModelAnimator.Cycle walk = ModelAnimator.cycle(state.walkAnimationPos * 0.125f, state.walkAnimationSpeed);){
            this.legFrontLeft.xRot = walk.eval(1.0f, 1.0f);
            this.legFrontRight.xRot = walk.eval(-1.0f, 1.0f);
            this.legBackLeft.xRot = walk.eval(-1.0f, 1.0f);
            this.legBackRight.xRot = walk.eval(1.0f, 1.0f);
            this.body.y += walk.eval(2.0f, 0.5f, 0.5f, 0.0f);
            this.body.zRot += walk.eval(1.0f, 0.15f);
        }
        if (state.vibing) {
            try (ModelAnimator.Cycle vibe = ModelAnimator.cycle(state.ageInTicks * 0.1f, 1.0f);){
                this.head.xRot += vibe.eval(1.0f, 0.1f);
            }
        }
        try (ModelAnimator.Cycle sniff = ModelAnimator.cycle(state.ageInTicks, 1.0f);){
            this.head.xRot += sniff.twitchSymmetric(40.0f, 0.15f, -0.08f);
        }
        try (ModelAnimator.Cycle whiskers = ModelAnimator.cycle(state.ageInTicks * 0.3f, 0.025f);){
            this.whiskerLeft1.xRot += whiskers.eval(1.0f, 1.0f, 0.25f, 0.0f);
            this.whiskerLeft2.xRot += whiskers.eval(1.0f, 1.0f, 0.0f, 0.0f);
            this.whiskerRight1.xRot += whiskers.eval(1.0f, 1.0f, 0.0f, 0.0f);
            this.whiskerRight2.xRot += whiskers.eval(1.0f, 1.0f, 0.25f, 0.0f);
        }
        try (ModelAnimator.Cycle idle = ModelAnimator.cycle(state.ageInTicks, 1.0f);){
            this.earLeft.xRot += idle.twitchSymmetric(7.0f, 0.22f, 1.0f);
            this.earRight.xRot += idle.twitchSymmetric(7.0f, 0.18f, 1.0f);
        }
    }
}

