/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.tropicraft.core.client.entity.model.ModelAnimator;

public class HummingbirdModel
extends EntityModel<LivingEntityRenderState> {
    private final ModelPart wing_left;
    private final ModelPart head_base;
    private final ModelPart wing_right;

    public HummingbirdModel(ModelPart root) {
        super(root);
        this.wing_left = root.getChild("wing_left");
        this.head_base = root.getChild("head_base");
        this.wing_right = root.getChild("wing_right");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("body_base", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("tail_base", CubeListBuilder.create().texOffs(0, 6).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 4.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)1.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("wing_left", CubeListBuilder.create().texOffs(9, 11).addBox(0.0f, 0.0f, 0.0f, 4.0f, 2.0f, 0.0f), PartPose.offsetAndRotation((float)1.0f, (float)-2.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headBase = root.addOrReplaceChild("head_base", CubeListBuilder.create().texOffs(9, 0).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        headBase.addOrReplaceChild("beak_base", CubeListBuilder.create().texOffs(7, 6).addBox(0.0f, 0.0f, -3.0f, 0.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-1.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("wing_right", CubeListBuilder.create().texOffs(0, 11).addBox(-4.0f, 0.0f, 0.0f, 4.0f, 2.0f, 0.0f), PartPose.offsetAndRotation((float)-1.0f, (float)-2.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void setupAnim(LivingEntityRenderState state) {
        super.setupAnim((EntityRenderState)state);
        ModelAnimator.look(this.head_base, state);
        try (ModelAnimator.Cycle fly = ModelAnimator.cycle(state.ageInTicks * 0.25f, 1.0f);){
            this.root.y = 20.0f + fly.eval(1.0f, 0.1f);
            this.wing_right.yRot = fly.eval(1.0f, 1.0f, 0.0f, 0.0f);
            this.wing_left.yRot = fly.eval(1.0f, -1.0f, 0.0f, 0.0f);
            this.wing_right.zRot = fly.eval(1.0f, 0.4f, 0.0f, 0.3f);
            this.wing_left.zRot = fly.eval(1.0f, -0.4f, 0.0f, -0.3f);
            this.wing_right.xRot = fly.eval(1.0f, 0.4f, 0.1f, 0.2f);
            this.wing_left.xRot = fly.eval(1.0f, 0.4f, 0.1f, 0.2f);
        }
    }
}

