/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.tropicraft.core.client.entity.model.ModelAnimator;

public class JaguarModel
extends EntityModel<LivingEntityRenderState> {
    private final ModelPart leg_back_left;
    private final ModelPart leg_front_left;
    private final ModelPart head_base;
    private final ModelPart leg_front_right;
    private final ModelPart leg_back_right;

    public JaguarModel(ModelPart root) {
        super(root);
        ModelPart body_base = root.getChild("body_base");
        this.leg_back_left = body_base.getChild("leg_back_left");
        ModelPart torso_main = body_base.getChild("torso_main");
        this.leg_front_left = torso_main.getChild("leg_front_left");
        this.head_base = root.getChild("head_base");
        this.leg_front_right = torso_main.getChild("leg_front_right");
        this.leg_back_right = body_base.getChild("leg_back_right");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body_base", CubeListBuilder.create().texOffs(37, 0).addBox(-3.5f, -1.0f, -4.0f, 7.0f, 8.0f, 10.0f, false), PartPose.offset((float)0.0f, (float)9.0f, (float)4.0f));
        PartDefinition tail = body.addOrReplaceChild("tail_base", CubeListBuilder.create().texOffs(54, 20).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 9.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)6.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition tailTip = tail.addOrReplaceChild("tail_tip", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)9.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        tailTip.addOrReplaceChild("tail_tip_r1", CubeListBuilder.create().mirror(false).texOffs(29, 20).addBox(-1.5f, -3.0f, 0.0f, 3.0f, 3.0f, 9.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("leg_back_left", CubeListBuilder.create().texOffs(0, 55).addBox(-3.0f, -2.0f, -2.0f, 3.0f, 13.0f, 4.0f, false), PartPose.offset((float)4.5f, (float)4.0f, (float)3.0f));
        PartDefinition torso = body.addOrReplaceChild("torso_main", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -1.0f, -10.0f, 8.0f, 9.0f, 10.0f, false), PartPose.offset((float)0.0f, (float)0.0f, (float)-4.0f));
        torso.addOrReplaceChild("leg_front_left", CubeListBuilder.create().texOffs(15, 35).addBox(-2.0f, -2.0f, -1.0f, 3.0f, 15.0f, 4.0f, false), PartPose.offset((float)4.0f, (float)2.0f, (float)-8.0f));
        PartDefinition head = root.addOrReplaceChild("head_base", CubeListBuilder.create().texOffs(0, 20).addBox(-3.5f, -2.0f, -7.0f, 7.0f, 7.0f, 7.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)-10.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("head_snout", CubeListBuilder.create().texOffs(15, 55).addBox(-2.5f, 0.0f, -4.0f, 5.0f, 6.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-7.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition earLeft = head.addOrReplaceChild("ear_left", CubeListBuilder.create(), PartPose.offsetAndRotation((float)2.0f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)-0.5672f, (float)0.3927f));
        earLeft.addOrReplaceChild("ear_left_r1", CubeListBuilder.create().texOffs(34, 55).addBox(0.0f, -2.0f, 0.0f, 3.0f, 3.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition earRight = head.addOrReplaceChild("ear_right", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.0f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)0.5672f, (float)-0.3927f));
        earRight.addOrReplaceChild("ear_right_r1", CubeListBuilder.create().texOffs(15, 66).addBox(-3.0f, -2.0f, 0.0f, 3.0f, 3.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        torso.addOrReplaceChild("leg_front_right", CubeListBuilder.create().texOffs(0, 35).addBox(-1.0f, -2.0f, -1.0f, 3.0f, 15.0f, 4.0f, false), PartPose.offset((float)-4.0f, (float)2.0f, (float)-8.0f));
        body.addOrReplaceChild("leg_back_right", CubeListBuilder.create().texOffs(30, 35).addBox(0.0f, -2.0f, -2.0f, 3.0f, 13.0f, 4.0f, false), PartPose.offset((float)-4.5f, (float)4.0f, (float)3.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public static LayerDefinition createBaby() {
        return JaguarModel.create().apply(ModelAnimator.hierarchicalBaby("head_base", 0.5f));
    }

    public void setupAnim(LivingEntityRenderState state) {
        super.setupAnim((EntityRenderState)state);
        ModelAnimator.look(this.head_base, state);
        try (ModelAnimator.Cycle walk = ModelAnimator.cycle(state.walkAnimationPos * 0.1f, state.walkAnimationSpeed);){
            this.leg_front_left.xRot = walk.eval(1.0f, 0.8f);
            this.leg_front_right.xRot = walk.eval(-1.0f, 0.8f);
            this.leg_back_left.xRot = walk.eval(-1.0f, 0.8f);
            this.leg_back_right.xRot = walk.eval(1.0f, 0.8f);
        }
    }
}

