/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.util.Mth;
import net.tropicraft.core.client.entity.model.ModelAnimator;
import net.tropicraft.core.client.entity.render.state.KoaRenderState;

public class KoaModel
extends HumanoidModel<KoaRenderState> {
    private final ModelPart headband;
    private final ModelPart armbandR;
    private final ModelPart leaf1;
    private final ModelPart leaf3;
    private final ModelPart leaf2;
    private final ModelPart leaf4;
    private final ModelPart leaf5;
    private final ModelPart leaf6;
    private final ModelPart leaf7;
    private final ModelPart leaf8;
    private final ModelPart leaf9;
    private final ModelPart leaf10;
    private final ModelPart armbandL;

    public KoaModel(ModelPart root) {
        super(root);
        this.headband = this.head.getChild("headband");
        this.armbandR = this.rightArm.getChild("armbandR");
        this.armbandL = this.leftArm.getChild("armbandL");
        this.leaf1 = this.headband.getChild("leaf1");
        this.leaf3 = this.headband.getChild("leaf3");
        this.leaf2 = this.headband.getChild("leaf2");
        this.leaf4 = this.headband.getChild("leaf4");
        this.leaf5 = this.headband.getChild("leaf5");
        this.leaf6 = this.headband.getChild("leaf6");
        this.leaf7 = this.headband.getChild("leaf7");
        this.leaf8 = this.headband.getChild("leaf8");
        this.leaf9 = this.headband.getChild("leaf9");
        this.leaf10 = this.headband.getChild("leaf10");
        this.hat.visible = false;
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = KoaModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition root = mesh.getRoot();
        PartDefinition modelPartHead = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 2).mirror().addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition modelPartHeadBand = modelPartHead.addOrReplaceChild("headband", CubeListBuilder.create().texOffs(24, 1).mirror().addBox(-5.0f, 0.0f, -5.0f, 10.0f, 2.0f, 10.0f), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition modelPartRightArm = root.getChild("right_arm");
        modelPartRightArm.addOrReplaceChild("armbandR", CubeListBuilder.create().texOffs(35, 6).mirror().addBox(2.5f, -2.0f, -2.5f, 5.0f, 1.0f, 5.0f), PartPose.offset((float)-6.0f, (float)3.0f, (float)0.0f));
        PartDefinition modelPartLeftArm = root.getChild("left_arm");
        modelPartLeftArm.addOrReplaceChild("armbandL", CubeListBuilder.create().texOffs(34, 1).mirror().addBox(-7.5f, -2.0f, -2.5f, 5.0f, 1.0f, 5.0f), PartPose.offset((float)6.0f, (float)3.0f, (float)0.0f));
        modelPartHeadBand.addOrReplaceChild("leaf1", KoaModel.leafModelBuilder(), PartPose.offset((float)2.0f, (float)-6.0f, (float)-6.0f));
        modelPartHeadBand.addOrReplaceChild("leaf3", KoaModel.leafModelBuilder(), PartPose.offset((float)-1.0f, (float)-6.0f, (float)-6.0f));
        modelPartHeadBand.addOrReplaceChild("leaf2", KoaModel.leafModelBuilder(), PartPose.offset((float)-4.0f, (float)-6.0f, (float)-6.0f));
        modelPartHeadBand.addOrReplaceChild("leaf4", KoaModel.leafModelBuilder(), PartPose.offset((float)0.0f, (float)-7.0f, (float)-6.0f));
        modelPartHeadBand.addOrReplaceChild("leaf5", KoaModel.leafModelBuilder(), PartPose.offset((float)5.0f, (float)-6.0f, (float)-1.0f));
        modelPartHeadBand.addOrReplaceChild("leaf6", KoaModel.leafModelBuilder(), PartPose.offset((float)5.0f, (float)-6.0f, (float)3.0f));
        modelPartHeadBand.addOrReplaceChild("leaf7", KoaModel.leafModelBuilder(), PartPose.offset((float)-6.0f, (float)-6.0f, (float)0.0f));
        modelPartHeadBand.addOrReplaceChild("leaf8", KoaModel.leafModelBuilder(), PartPose.offset((float)-6.0f, (float)-6.0f, (float)-4.0f));
        modelPartHeadBand.addOrReplaceChild("leaf9", KoaModel.leafModelBuilder(), PartPose.offset((float)-2.0f, (float)-6.0f, (float)5.0f));
        modelPartHeadBand.addOrReplaceChild("leaf10", KoaModel.leafModelBuilder(), PartPose.offset((float)2.0f, (float)-6.0f, (float)5.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public static LayerDefinition createBaby() {
        return KoaModel.create().apply(ModelAnimator.hierarchicalBaby("head", 0.5f, 0.75f));
    }

    public static CubeListBuilder leafModelBuilder() {
        return CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, 7.0f, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public void setupAnim(KoaRenderState state) {
        boolean isPassenger = state.isPassenger;
        state.isPassenger |= state.isSitting;
        super.setupAnim((HumanoidRenderState)state);
        state.isPassenger = isPassenger;
        this.hat.visible = false;
        if (state.isDancing) {
            float danceAnimation = state.ageInTicks * 35.0f * ((float)Math.PI / 180);
            float headRot = Mth.cos((float)danceAnimation);
            this.head.zRot = headRot * 0.05f;
            this.head.xRot += Mth.sin((float)danceAnimation) * 0.05f;
            float amp = 0.5f;
            float x = 3.926991f + headRot * amp;
            float y = headRot * amp;
            float z = headRot * amp;
            this.rightArm.xRot += x;
            this.rightArm.yRot += y;
            this.rightArm.zRot += z;
            this.leftArm.xRot += x;
            this.leftArm.yRot += y;
            this.leftArm.zRot += z;
        }
    }
}

